/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.views.UmlExplorerLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

class UmlExplorerLabelProvider
extends StyledCellLabelProvider {
    private IModelingSession modelingSession;
    private final UmlExplorerTextProvider textProvider = new UmlExplorerTextProvider();
    private final UmlExplorerFontProvider fontProvider;
    private final UmlExplorerStyleProvider styleProvider = new UmlExplorerStyleProvider();
    private final UmlExplorerImageProvider imageProvider;

    public UmlExplorerLabelProvider() {
        this.fontProvider = new UmlExplorerFontProvider();
        this.imageProvider = new UmlExplorerImageProvider();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void startSession(IModelingSession theModelingSession) {
        this.modelingSession = theModelingSession;
    }

    public void stopSession() {
        this.modelingSession = null;
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        if (obj == null) {
            super.update(cell);
            return;
        }
        if (obj instanceof ModelElementAdapter) {
            this.update(cell, (ModelElementAdapter)obj);
            return;
        }
        if (obj instanceof DependencyContainerAdapter) {
            this.update(cell, (DependencyContainerAdapter)obj);
            return;
        }
        super.update(cell);
    }

    private void update(ViewerCell cell, DependencyContainerAdapter dca) {
        super.update(cell);
        cell.setText(this.textProvider.getText(dca));
        cell.setImage(this.imageProvider.getLinkContainerImage());
    }

    private void update(ViewerCell cell, ModelElementAdapter mea) {
        super.update(cell);
        if (this.modelingSession != null) {
            IElement element = mea.getElement();
            String text = this.textProvider.getText(element);
            cell.setFont(this.fontProvider.getFont(element));
            cell.setImage(this.imageProvider.getModelElementImage(mea));
            cell.setText(text);
            cell.setStyleRanges(this.styleProvider.getStyleRanges(element, text, element.getElementStatus()));
        }
    }
}

