/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.views;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.explorer.views.UmlExplorerCanBeSelectedVisitor;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.commands.ICommandService;

class UmlExplorerNavigateListener
implements INavigationListener {
    private UmlNavigatorView view;

    public UmlExplorerNavigateListener(UmlNavigatorView view) {
        this.view = view;
    }

    public void navigateTo(IElement target) {
        this.view.selectElement(target);
        this.view.getCommonViewer().refresh();
        List selectedElements = this.getSelectedElements();
        UmlExplorerCanBeSelectedVisitor visitor = new UmlExplorerCanBeSelectedVisitor();
        if (!selectedElements.contains(target) && visitor.canBeSelected(target)) {
            this.view.setInput(this.view.getRootInput());
            ViewerFilter[] filter = new ViewerFilter[]{};
            this.view.getCommonViewer().setFilters(filter);
            if (this.view != null) {
                ICommandService commandService = (ICommandService)this.view.getSite().getService(ICommandService.class);
                commandService.refreshElements("com.modeliosoft.modelio.explorer.SelectRootHandlerID", null);
            }
            this.view.selectElement(target);
        } else if (target instanceof ILifeline && ((ILifeline)target).getRepresented() != null) {
            this.navigateTo((IElement)((ILifeline)target).getRepresented());
        }
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        ISelection selection = this.view.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                if (!(obj instanceof IAdaptable)) continue;
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }
}

