/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.explorer.views;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IUsage;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageMerge;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.INavigationService;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.IPickingProviderService;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.explorer.model.RootElementAdapter;
import com.modeliosoft.modelio.explorer.model.UmlContentProvider;
import com.modeliosoft.modelio.explorer.views.ElementNameModifier;
import com.modeliosoft.modelio.explorer.views.ExplorerEditorActivationStrategy;
import com.modeliosoft.modelio.explorer.views.UmlExplorerActionsManager;
import com.modeliosoft.modelio.explorer.views.UmlExplorerActivateListener;
import com.modeliosoft.modelio.explorer.views.UmlExplorerActivateSender;
import com.modeliosoft.modelio.explorer.views.UmlExplorerLabelProvider;
import com.modeliosoft.modelio.explorer.views.UmlExplorerNavigateListener;
import com.modeliosoft.modelio.explorer.views.UmlExplorerPickingManager;
import com.modeliosoft.modelio.explorer.views.UmlExplorerViewUpdater;
import com.modeliosoft.modelio.explorer.views.UmlNavigatorModelChangeListener;
import com.modeliosoft.modelio.explorer.views.UmlTreeViewerListener;
import com.modeliosoft.modelio.explorer.views.history.SelectionHistory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class UmlNavigatorView
extends CommonNavigator
implements ISessionListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.explorer.UmlNavigatorContentID";
    UmlNavigatorModelChangeListener modelChangeListener;
    private UmlTreeViewerListener umlTreelistener;
    public static final String CONTENT_NAVIGATOR_ID = "com.modeliosoft.modelio.explorer.UmlNavigatorContentID";
    private UmlContentProvider contentProvider;
    private ElementNameModifier nameModifier;
    private SelectionHistory selectionHistory;
    private UmlExplorerActionsManager actionsManager;
    private UmlExplorerNavigateListener umlExplorerNavigateListener;
    private UmlExplorerActivateSender activateSender = new UmlExplorerActivateSender();
    private IModelingSession modelingSession;
    private UmlExplorerPickingManager explorerPickingManager;
    private UmlExplorerLabelProvider labelProvider;
    private UmlExplorerViewUpdater viewUpdater = new UmlExplorerViewUpdater(this);
    protected IElement rootInput = null;
    protected IElement input = null;
    private ExplorerEditorActivationStrategy activationSupport = null;
    private Clipboard clipboard;

    protected IAdaptable getInitialInput() {
        return null;
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[1];
        TextCellEditor editor = new TextCellEditor((Composite)this.getCommonViewer().getTree(), 0);
        editor.getControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        cellEditors[0] = editor;
        this.getCommonViewer().setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.getCommonViewer().setColumnProperties(properties);
        this.nameModifier = new ElementNameModifier(this);
        this.getCommonViewer().setCellModifier((ICellModifier)this.nameModifier);
        this.activationSupport = new ExplorerEditorActivationStrategy((ColumnViewer)this.getCommonViewer());
        TreeViewerEditor.create((TreeViewer)this.getCommonViewer(), null, (ColumnViewerEditorActivationStrategy)this.activationSupport, (int)58);
    }

    public void dispose() {
        if (this.modelingSession != null) {
            this.sessionClosed(this.modelingSession);
        }
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.removeNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
        IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
        pickingService.removePickingProvider((IPickingProvider)this.explorerPickingManager);
        this.explorerPickingManager.dispose();
        this.explorerPickingManager = null;
        Tree tree = this.getCommonViewer().getTree();
        if (!tree.isDisposed()) {
            tree.removeSelectionListener((SelectionListener)this.selectionHistory);
        }
        this.selectionHistory = null;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        if (!tree.isDisposed()) {
            tree.removeMouseListener((MouseListener)this.activateSender);
        }
        this.activateSender = null;
        this.labelProvider = null;
        super.dispose();
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        this.labelProvider.startSession(this.modelingSession);
        this.viewUpdater.start(this.modelingSession);
        this.modelChangeListener = new UmlNavigatorModelChangeListener(this);
        this.modelingSession.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
        this.modelingSession.getModel().addStatusListener((IStatusChangeListener)this.modelChangeListener);
        this.modelingSession.getModel().addModelListener((IModelChangeListener)this.selectionHistory);
        IProject project = session.getModel().getProject();
        this.setRootInput((IElement)project.getModel());
    }

    public void sessionClosed(IModelingSession session) {
        if (this.modelingSession == null) {
            return;
        }
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this.selectionHistory);
        this.selectionHistory.clear();
        Tree tree = this.getCommonViewer().getTree();
        if (this.activationSupport != null && !tree.isDisposed()) {
            tree.removeMouseListener((MouseListener)this.activationSupport);
        }
        this.activationSupport = null;
        this.modelingSession.getModel().removeStatusListener((IStatusChangeListener)this.modelChangeListener);
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
        this.modelChangeListener = null;
        this.viewUpdater.stop();
        this.labelProvider.stopSession();
        this.modelingSession = null;
        if (!tree.isDisposed()) {
            this.setRootInput(null);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getCommonViewer().setSorter(null);
        this.getCommonViewer().setAutoExpandLevel(1);
        INavigatorContentService contentService = this.getCommonViewer().getNavigatorContentService();
        INavigatorContentExtension contentExtension = contentService.getContentExtensionById("com.modeliosoft.modelio.explorer.UmlNavigatorContentID");
        this.contentProvider = (UmlContentProvider)contentExtension.getContentProvider();
        this.getCommonViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.initEditor();
        this.umlTreelistener = new UmlTreeViewerListener(this);
        this.getCommonViewer().addTreeListener((ITreeViewerListener)this.umlTreelistener);
        this.initActionsManager();
        IContextService contextService = (IContextService)this.getViewSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.bindings.context.UmlNavigatorViewID");
        this.getViewSite().getActionBars().getMenuManager().removeAll();
        this.getViewSite().getActionBars().getMenuManager().update();
        this.clipboard = new Clipboard(Display.getCurrent());
        this.getCommonViewer().getTree().addMouseListener((MouseListener)this.activateSender);
        this.getCommonViewer().getTree().addSelectionListener((SelectionListener)this.selectionHistory);
        this.getCommonViewer().getTree().addMouseListener((MouseListener)this.activationSupport);
        this.setTitleToolTip("");
        this.explorerPickingManager = new UmlExplorerPickingManager(this);
        IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
        pickingService.addPickingProvider((IPickingProvider)this.explorerPickingManager);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
    }

    public void setInput(IElement element) {
        this.input = element;
        this.getCommonViewer().setInput((Object)new RootElementAdapter(this.input));
    }

    public void selectElement(IElement element) {
        ModelElementAdapter adapter;
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        if (this.isSecondaryLink(element)) {
            DependencyContainerAdapter dependencyAdapter;
            IElement parentElement = element.getCompositionOwner();
            this.setExpandedState(parentElement, true);
            ModelElementAdapter parentAdapter = adaptersCache.getAdapter(parentElement);
            if (parentAdapter != null && (dependencyAdapter = parentAdapter.getDependencyAdapter()) != null) {
                viewer.setExpandedState((Object)dependencyAdapter, true);
            }
        }
        if ((adapter = adaptersCache.getAdapter(element)) != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)adapter), true);
        } else {
            IElement parentElement = element.getCompositionOwner();
            if (parentElement != null && !(parentElement instanceof IProject)) {
                this.setExpandedState(parentElement, true);
                adapter = adaptersCache.getAdapter(element);
                if (adapter != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)adapter), true);
                }
            }
        }
    }

    public void setExpandedState(IElement element, boolean expanded) {
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        ModelElementAdapter adapter = adaptersCache.getAdapter(element);
        if (adapter != null) {
            viewer.setExpandedState((Object)adapter, expanded);
        } else {
            IElement parentElement = element.getCompositionOwner();
            if (parentElement != null && !(parentElement instanceof IProject)) {
                this.setExpandedState(parentElement, true);
            } else {
                RootElementAdapter rootAdapter;
                List children;
                Object viewerInput = viewer.getInput();
                if (viewerInput instanceof RootElementAdapter && (children = (rootAdapter = (RootElementAdapter)viewerInput).getChildrenAdapters()).size() > 0) {
                    viewer.setExpandedState(children.get(0), expanded);
                }
            }
            adapter = adaptersCache.getAdapter(element);
            if (adapter != null) {
                viewer.setExpandedState((Object)adapter, expanded);
            }
        }
    }

    public UmlContentProvider getContentProvider() {
        return this.contentProvider;
    }

    UmlExplorerActionsManager getActionsManager() {
        return this.actionsManager;
    }

    public void selectElements(List<IElement> elements) {
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        ArrayList<ModelElementAdapter> adaptersToSelect = new ArrayList<ModelElementAdapter>();
        for (IElement element : elements) {
            ModelElementAdapter adapter = adaptersCache.getAdapter(element);
            if (adapter != null) {
                adaptersToSelect.add(adapter);
                continue;
            }
            IElement parentElement = element.getCompositionOwner();
            if (parentElement == null || parentElement instanceof IProject) continue;
            this.setExpandedState(parentElement, true);
            adapter = adaptersCache.getAdapter(element);
            if (adapter == null) continue;
            adaptersToSelect.add(adapter);
        }
        viewer.setSelection((ISelection)new StructuredSelection(adaptersToSelect), true);
    }

    private boolean isSecondaryLink(IElement element) {
        return element instanceof IDependency || element instanceof IElementImport || element instanceof IPackageImport || element instanceof IUsage || element instanceof IPackageMerge;
    }

    private void initActionsManager() {
        this.actionsManager = new UmlExplorerActionsManager(this);
    }

    public void setRootInput(IElement element) {
        if (this.getCommonViewer().getTree().isDisposed()) {
            return;
        }
        this.input = element;
        this.rootInput = element;
        this.getCommonViewer().setInput((Object)(this.rootInput == null ? null : new RootElementAdapter(this.rootInput)));
    }

    public IElement getRootInput() {
        return this.rootInput;
    }

    public IElement getInput() {
        return this.input;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.selectionHistory = new SelectionHistory(this);
        this.umlExplorerNavigateListener = new UmlExplorerNavigateListener(this);
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.addNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
        this.labelProvider = new UmlExplorerLabelProvider();
        new UmlExplorerActivateListener(this);
    }
}

