/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import com.sun.glass.ui.mac.MacTouchInputSupport;

public class MacGestureSupport {
    private static final int GESTURE_ROTATE = 100;
    private static final int GESTURE_MAGNIFY = 101;
    private static final int GESTURE_SWIPE = 102;
    private static final int SCROLL_SRC_WHEEL = 50;
    private static final int SCROLL_SRC_GESTURE = 51;
    private static final int SCROLL_SRC_INERTIA = 52;
    private static final boolean isDirect = false;
    private static final GestureSupport gestures = new GestureSupport(false);
    private static final TouchInputSupport touches = new MacTouchInputSupport(gestures.createTouchCountListener(), false);

    public static void notifyBeginTouchEvent(View view, int modifiers, int touchEventCount) {
        touches.notifyBeginTouchEvent(view, modifiers, false, touchEventCount);
    }

    public static void notifyNextTouchEvent(View view, int state, long id, float x, float y) {
        int intX = (int)(10000.0f * x);
        int intY = 10000 - (int)(10000.0f * y);
        touches.notifyNextTouchEvent(view, state, id, intX, intY, intX, intY);
    }

    public static void notifyEndTouchEvent(View view) {
        touches.notifyEndTouchEvent(view);
    }

    public static void rotateGesturePerformed(View view, int modifiers, int x, int y, int xAbs, int yAbs, float rotation) {
        gestures.handleDeltaRotation(view, modifiers, false, false, x, y, xAbs, yAbs, -rotation);
    }

    public static void scrollGesturePerformed(View view, int modifiers, int sender, int x, int y, int xAbs, int yAbs, float dx, float dy) {
        int touchCount = touches.getTouchCount();
        boolean isInertia = sender == 52;
        switch (sender) {
            case 50: 
            case 52: {
                GestureSupport.handleScrollingPerformed(view, modifiers, false, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy);
                break;
            }
            case 51: {
                gestures.handleDeltaScrolling(view, modifiers, false, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy);
            }
        }
    }

    public static void swipeGesturePerformed(View view, int modifiers, int dir, int x, int y, int xAbs, int yAbs) {
        GestureSupport.handleSwipePerformed(view, modifiers, false, false, touches.getTouchCount(), dir, x, y, xAbs, yAbs);
    }

    public static void magnifyGesturePerformed(View view, int modifiers, int x, int y, int xAbs, int yAbs, float scale) {
        gestures.handleDeltaZooming(view, modifiers, false, false, x, y, xAbs, yAbs, scale, Double.NaN);
    }

    public static void gestureFinished(View view, int modifiers, int x, int y, int xAbs, int yAbs) {
        if (gestures.isScrolling()) {
            gestures.handleScrollingEnd(view, modifiers, touches.getTouchCount(), false, false, x, y, xAbs, yAbs);
        }
        if (gestures.isRotating()) {
            gestures.handleRotationEnd(view, modifiers, false, false, x, y, xAbs, yAbs);
        }
        if (gestures.isZooming()) {
            gestures.handleZoomingEnd(view, modifiers, false, false, x, y, xAbs, yAbs);
        }
    }

    private static native void _initIDs();

    static {
        Application.loadNativeLibrary();
        MacGestureSupport._initIDs();
    }
}

