/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import javafx.application.Platform;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class GlassSceneDnDEventHandler {
    private final GlassScene scene;
    private final boolean verbose;
    private final DragEventListener del;
    private static final QuantumToolkit toolkit = (QuantumToolkit)QuantumToolkit.getToolkit();

    public GlassSceneDnDEventHandler(GlassScene glassScene, DragEventListener dragEventListener, boolean bl) {
        this.scene = glassScene;
        this.verbose = bl;
        this.del = dragEventListener;
    }

    public GlassSceneDnDEventHandler(GlassScene glassScene, DragEventListener dragEventListener) {
        this(glassScene, dragEventListener, false);
    }

    private static boolean toolkit() {
        return toolkit.getFxUserThread() != null;
    }

    public TransferMode handleDragEnter(int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        TransferMode transferMode = null;
        try {
            if (this.scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(3, n, n2, n3, n4, dragboard, 0, this.scene, n5, this.del);
                transferMode = this.scene.dropTargetListener.dragEnter(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return transferMode;
    }

    public void handleDragLeave(ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        try {
            if (this.scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(5, 0, 0, 0, 0, dragboard, 0, this.scene, 0, this.del);
                this.scene.dropTargetListener.dragExit(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    public TransferMode handleDragDrop(int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        TransferMode transferMode = null;
        try {
            Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
            GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(2, n, n2, n3, n4, dragboard, 0, this.scene, n5, this.del);
            if (this.scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                transferMode = this.scene.dropTargetListener.drop(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return transferMode;
    }

    public TransferMode handleDragOver(int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        TransferMode transferMode = null;
        try {
            if (this.scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(4, n, n2, n3, n4, dragboard, 0, this.scene, n5, this.del);
                transferMode = this.scene.dropTargetListener.dragOver(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        return transferMode;
    }

    public void handleDragStart(int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        try {
            if (this.scene.dragGestureListener != null && GlassSceneDnDEventHandler.toolkit()) {
                Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(1, n2, n3, n4, n5, dragboard, n, this.scene, 0, this.del);
                this.scene.dragGestureListener.dragGestureRecognized(glassDragEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    public void handleDragEnd(int n, ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        if (this.scene.dragSourceListener != null && GlassSceneDnDEventHandler.toolkit()) {
            Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
            GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(2, 0, 0, 0, 0, dragboard, 0, this.scene, n, this.del);
            this.scene.dragSourceListener.dragDropEnd(glassDragEvent);
        }
    }

    public TransferMode handleDragEnter(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragEnter(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public TransferMode handleDragDrop(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragDrop(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public TransferMode handleDragOver(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragOver(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public void handleDragEnd(TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        this.handleDragEnd(GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public static int TransferModeToAction(TransferMode transferMode) {
        if (transferMode == null) {
            return 0;
        }
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }

    public static Dragboard createDragboard(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
        return Dragboard.impl_create(quantumClipboard);
    }

    private static GlassDragEvent createEvent(int n, int n2, int n3, int n4, int n5, Dragboard dragboard, int n6, GlassScene glassScene, int n7, DragEventListener dragEventListener) {
        if (dragEventListener == null) {
            return new GlassDragEvent(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7);
        }
        return new GlassDragEventWithListener(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7, dragEventListener);
    }

    private static class GlassDragEventWithListener
    extends GlassDragEvent {
        private final DragEventListener del;

        GlassDragEventWithListener(int n, int n2, int n3, int n4, int n5, Dragboard dragboard, int n6, GlassScene glassScene, int n7, DragEventListener dragEventListener) {
            super(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7);
            this.del = dragEventListener;
        }

        @Override
        public void accept(TransferMode transferMode) {
            this.del.eventAccepted(transferMode);
        }

        @Override
        public void reject() {
            this.del.eventRejected();
        }
    }

    public static interface DragEventListener {
        public void eventAccepted(TransferMode var1);

        public void eventRejected();
    }
}

