/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.d3d;

import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.impl.hw.Drawable;
import com.sun.scenario.effect.impl.hw.RendererDelegate;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.impl.hw.Texture;
import com.sun.scenario.effect.impl.hw.d3d.D3DShader;
import com.sun.scenario.effect.impl.hw.d3d.D3DTexture;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public class D3DRendererDelegate
implements RendererDelegate {
    private long pd3dr;
    private RendererDelegate.Listener listener;

    public D3DRendererDelegate(long l) {
        this(l, true);
    }

    public D3DRendererDelegate(long l, boolean bl) {
        this.pd3dr = D3DRendererDelegate.init(l, bl);
    }

    @Override
    public Effect.AccelType getAccelType() {
        return Effect.AccelType.DIRECT3D;
    }

    private static native long init(long var0, boolean var2);

    private static native long enable(long var0);

    private static native long disable(long var0);

    private static native long getDevicePtr(long var0);

    private static native void dispose(long var0);

    @Override
    public void setListener(RendererDelegate.Listener listener) {
        this.listener = listener;
    }

    private void markLost() {
        if (this.listener != null) {
            this.listener.markLost();
        }
    }

    @Override
    public void enable() {
        long l = D3DRendererDelegate.enable(this.pd3dr);
        if (l < 0L) {
            this.markLost();
        }
    }

    @Override
    public void disable() {
        long l = D3DRendererDelegate.disable(this.pd3dr);
        if (l < 0L) {
            this.markLost();
        }
    }

    @Override
    public void dispose() {
        if (this.pd3dr != 0L) {
            D3DRendererDelegate.dispose(this.pd3dr);
            this.pd3dr = 0L;
        }
    }

    private static ByteBuffer getBuffer(String string) {
        try {
            Object object;
            InputStream inputStream = D3DRendererDelegate.class.getResourceAsStream("hlsl/" + string + ".obj");
            if (inputStream == null) {
                throw new RuntimeException("D3D shader object not found for " + string);
            }
            int n = 4096;
            Object object2 = new byte[n];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
            int n2 = 0;
            int n3 = -1;
            while ((n3 = bufferedInputStream.read((byte[])object2, n2, n - n2)) != -1) {
                if (n - (n2 += n3) != 0) continue;
                object = new byte[n *= 2];
                System.arraycopy(object2, 0, object, 0, ((byte[])object2).length);
                object2 = object;
            }
            bufferedInputStream.close();
            object = ByteBuffer.allocateDirect(n2);
            ((ByteBuffer)object).put((byte[])object2, 0, n2);
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error loading D3D shader object", iOException);
        }
    }

    @Override
    public Shader createShader(String string, Map<String, Integer> map, Map<String, Integer> map2) {
        return new D3DShader(this.pd3dr, D3DRendererDelegate.getBuffer(string), map2);
    }

    static native void setBlendMode(long var0, int var2);

    static native long createFloatTexture(long var0, int var2, int var3);

    @Override
    public Texture createFloatTexture(int n, int n2) {
        long l = D3DRendererDelegate.createFloatTexture(this.pd3dr, n, n2);
        return D3DTexture.create(l, n, n2);
    }

    static native void updateFloatTexture(long var0, long var2, float[] var4, int var5, int var6);

    @Override
    public void updateFloatTexture(Object object, FloatMap floatMap) {
        Texture texture = (Texture)object;
        D3DRendererDelegate.updateFloatTexture(this.pd3dr, texture.getNativeSourceHandle(), floatMap.getData(), floatMap.getWidth(), floatMap.getHeight());
    }

    static native long drawQuad(long var0, long var2, float var4, float var5, float var6, float var7);

    @Override
    public void drawQuad(Drawable drawable, float f, float f2, float f3, float f4) {
        D3DRendererDelegate.drawQuad(this.pd3dr, drawable.getNativeDestHandle(), f, f2, f3, f4);
    }

    static native long drawTexture(long var0, long var2, long var4, boolean var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);

    @Override
    public void drawTexture(Drawable drawable, Texture texture, boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        D3DRendererDelegate.drawTexture(this.pd3dr, drawable.getNativeDestHandle(), texture.getNativeSourceHandle(), bl, f, f2, f3, f4, f5, f6, f7, f8);
    }

    static native long drawMappedTexture(long var0, long var2, long var4, boolean var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18);

    @Override
    public void drawMappedTexture(Drawable drawable, Texture texture, boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        D3DRendererDelegate.drawMappedTexture(this.pd3dr, drawable.getNativeDestHandle(), texture.getNativeSourceHandle(), bl, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    static native long drawTexture2(long var0, long var2, long var4, boolean var6, long var7, boolean var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21);

    @Override
    public void drawTexture(Drawable drawable, Texture texture, boolean bl, Texture texture2, boolean bl2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        D3DRendererDelegate.drawTexture2(this.pd3dr, drawable.getNativeDestHandle(), texture.getNativeSourceHandle(), bl, texture2.getNativeSourceHandle(), bl2, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    static native long drawMappedTexture2(long var0, long var2, long var4, boolean var6, long var7, boolean var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25, float var26, float var27, float var28, float var29);

    @Override
    public void drawMappedTexture(Drawable drawable, Texture texture, boolean bl, Texture texture2, boolean bl2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        D3DRendererDelegate.drawMappedTexture2(this.pd3dr, drawable.getNativeDestHandle(), texture.getNativeSourceHandle(), bl, texture2.getNativeSourceHandle(), bl2, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NativeLibLoader.loadLibrary("decora-d3d");
                return null;
            }
        });
    }
}

