/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStyleKeyProvider {
    private ArrayList<StyleKey> allKeys = null;

    public List<StyleKey> getStyleKeys() {
        if (this.allKeys == null) {
            this.allKeys = new ArrayList();
            this.scanForStyleKeys(this.getClass());
        }
        return this.allKeys;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        for (StyleKey s : this.getStyleKeys()) {
            if (!metakey.equals(s.getMetakey())) continue;
            return s;
        }
        return null;
    }

    private void scanForStyleKeys(Class<?> aClass) throws SecurityException {
        AccessibleObject[] declaredFields = aClass.getDeclaredFields();
        AccessibleObject.setAccessible(declaredFields, true);
        AnnotatedElement[] annotatedElementArray = declaredFields;
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            AccessibleObject field = annotatedElementArray[n2];
            if (((Field)field).getType() == StyleKey.class) {
                try {
                    StyleKey styleKey = (StyleKey)((Field)field).get(null);
                    this.allKeys.add(styleKey);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
                }
            }
            ++n2;
        }
        annotatedElementArray = aClass.getClasses();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement innerClass = annotatedElementArray[n2];
            this.scanForStyleKeys((Class)innerClass);
            ++n2;
        }
    }
}

