/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.styles.core.AbstractStyleKeyProvider;
import com.modeliosoft.modelio.diagram.styles.core.FactoryStyleDefaults;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class FactoryStyle
implements IStyle,
IPersistent {
    private static FactoryStyle _instance = null;
    private static Map<StyleKey, Object> properties = null;
    private FactoryStyleDefaults factoryStyleDefaults = new FactoryStyleDefaults();
    private static final int MAJOR_VERSION = 0;

    public static FactoryStyle getInstance() {
        if (_instance == null) {
            _instance = new FactoryStyle();
        }
        return _instance;
    }

    private FactoryStyle() {
        properties = new HashMap();
    }

    public void addListener(IStyleChangeListener l) {
    }

    public void declareProvider(Class<? extends AbstractStyleKeyProvider> styleProvider) throws IllegalArgumentException {
        try {
            styleProvider.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean getBoolean(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Boolean) {
            return (Boolean)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a boolean value");
    }

    public IStyle getCascadedStyle() {
        return this;
    }

    public Color getColor(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Color) {
            return (Color)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a color");
    }

    public Font getFont(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Font) {
            return (Font)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a font");
    }

    public int getInteger(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Integer) {
            return (Integer)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a integer value");
    }

    public Set<StyleKey> getLocalKeys() {
        return properties.keySet();
    }

    public <T> T getProperty(StyleKey propertyKey) {
        Object value = properties.get(propertyKey);
        if (value == null) {
            value = this.factoryStyleDefaults.getDefaultValue(propertyKey);
        }
        assert (value != null) : "No factory setting for property " + propertyKey;
        return (T)value;
    }

    public void injectDefaultValues(Map<StyleKey, Object> defaultValues) {
        for (StyleKey sKey : defaultValues.keySet()) {
            assert (defaultValues.get(sKey) != null);
            properties.put(sKey, defaultValues.get(sKey));
        }
    }

    public boolean isExternal(IDiagramWriter out) {
        return true;
    }

    public boolean isLocal(StyleKey propertyKey) {
        return properties.containsKey(propertyKey);
    }

    public void read(IDiagramReader in) {
    }

    public void removeListener(IStyleChangeListener l) {
    }

    public void removeProperty(StyleKey key) {
        if (properties != null) {
            properties.remove(key);
        }
    }

    public void reset() {
        throw new IllegalArgumentException("FactorySettings cannot be resetted");
    }

    public void setCascadedStyle(IStyle style) {
        throw new UnsupportedOperationException("Illegal attempt to set factory parent style");
    }

    public void setProperty(StyleKey key, Object value) {
        throw new UnsupportedOperationException("Illegal attempt to set factory setting for property " + key);
    }

    public void write(IDiagramWriter out) {
        out.writeExtRef((IPersistent)this, "", "factory");
    }

    public void normalize() {
    }

    public int getMajorVersion() {
        return 0;
    }
}

