/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FactoryStyleDefaults {
    private static Color defaultFillColor = null;
    private static Color defaultPenColor = null;
    private static Color defaultTextColor = null;
    private static Font defaultMediumFont = null;
    private static StyleKey.LinePattern defaultLinePattern = null;
    private static StyleKey.FillMode defaultFillMode = null;
    private static StyleKey.RepresentationMode defaultRepMode = null;
    private static StyleKey.ShowNameMode defaultShowNameMode = null;
    private static StyleKey.ShowStereotypeMode defaultShowStereotypesMode = null;
    private static StyleKey.ConnectionRouterId defaultRoutingMode = StyleKey.ConnectionRouterId.ORTHOGONAL;
    private static Integer defaultLineWidth = null;
    private static Boolean defaultShowTagsMode = null;
    private static Integer defaultLineRadius = null;

    public FactoryStyleDefaults() {
        if (defaultPenColor == null) {
            defaultPenColor = ColorConstants.darkGray;
            defaultTextColor = ColorConstants.black;
            defaultFillColor = ColorConstants.white;
            defaultMediumFont = new Font((Device)Display.getDefault(), "Arial", 10, 0);
            defaultFillMode = StyleKey.FillMode.SOLID;
            defaultLinePattern = StyleKey.LinePattern.LINE_SOLID;
            defaultLineWidth = 1;
            defaultLineRadius = 0;
            defaultRepMode = StyleKey.RepresentationMode.STRUCTURED;
            defaultShowNameMode = StyleKey.ShowNameMode.SIMPLE;
            defaultShowStereotypesMode = StyleKey.ShowStereotypeMode.NONE;
            defaultShowTagsMode = false;
        }
    }

    public Object getDefaultValue(StyleKey sKey) {
        if (sKey.getMetakey() != null) {
            return this.getDefaultValue(sKey.getMetakey());
        }
        return this.getDefaultValue(sKey.getType());
    }

    private Object getDefaultValue(Class<?> type) {
        if (type == Font.class) {
            return defaultMediumFont;
        }
        LOG.error((String)"org.modelio.diagram.styles", (String)"FactoryStyleDefaults: cannot guess a default for type '%s'", (Object[])new Object[]{type.getSimpleName()});
        return null;
    }

    private Object getDefaultValue(MetaKey metaKey) {
        if (MetaKey.FILLCOLOR.equals(metaKey)) {
            return defaultFillColor;
        }
        if (MetaKey.FILLMODE.equals(metaKey)) {
            return defaultFillMode;
        }
        if (MetaKey.FONT.equals(metaKey)) {
            return defaultMediumFont;
        }
        if (MetaKey.LINECOLOR.equals(metaKey)) {
            return defaultPenColor;
        }
        if (MetaKey.LINEWIDTH.equals(metaKey)) {
            return defaultLineWidth;
        }
        if (MetaKey.LINERADIUS.equals(metaKey)) {
            return defaultLineRadius;
        }
        if (MetaKey.REPMODE.equals(metaKey)) {
            return defaultRepMode;
        }
        if (MetaKey.SHOWNAME.equals(metaKey)) {
            return defaultShowNameMode;
        }
        if (MetaKey.SHOWSTEREOTYPES.equals(metaKey)) {
            return defaultShowStereotypesMode;
        }
        if (MetaKey.SHOWTAGS.equals(metaKey)) {
            return defaultShowTagsMode;
        }
        if (MetaKey.TEXTCOLOR.equals(metaKey)) {
            return defaultTextColor;
        }
        if (MetaKey.LINEPATTERN.equals(metaKey)) {
            return defaultLinePattern;
        }
        if (MetaKey.CONNECTIONROUTER.equals(metaKey)) {
            return defaultRoutingMode;
        }
        LOG.error((String)"org.modelio.diagram.styles", (String)"FactoryStyleDefaults(): cannot guess a default value for unknown metakey '%s'", (Object[])new Object[]{metaKey});
        return null;
    }
}

