/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class ProxyStyle
implements IPersistent,
IStyle,
IStyleChangeListener {
    private IStyle cascadedStyle = null;
    private List<IStyleChangeListener> listeners = new ArrayList();
    private static final int MAJOR_VERSION = 0;

    public ProxyStyle() {
    }

    public ProxyStyle(IStyle cascadedStyle) {
        assert (cascadedStyle != null);
        this.cascadedStyle = cascadedStyle;
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
    }

    public void addListener(IStyleChangeListener l) {
        this.listeners.add(l);
    }

    public boolean getBoolean(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Boolean) {
            return (Boolean)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException(String.valueOf(this.getIllegalArgumentMessagePrefix(propertyKey)) + "a boolean value");
    }

    public IStyle getCascadedStyle() {
        return this.cascadedStyle;
    }

    public Color getColor(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Color) {
            return (Color)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException(String.valueOf(this.getIllegalArgumentMessagePrefix(propertyKey)) + "a color");
    }

    public Font getFont(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Font) {
            return (Font)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException(String.valueOf(this.getIllegalArgumentMessagePrefix(propertyKey)) + "a font");
    }

    public int getInteger(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Integer) {
            return (Integer)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException(String.valueOf(this.getIllegalArgumentMessagePrefix(propertyKey)) + "an integer value");
    }

    public Set<StyleKey> getLocalKeys() {
        return this.getCascadedStyle().getLocalKeys();
    }

    public <T> T getProperty(StyleKey key) {
        return (T)this.cascadedStyle.getProperty(key);
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public boolean isLocal(StyleKey propertyKey) {
        return this.getCascadedStyle().isLocal(propertyKey);
    }

    public void normalize() {
        this.cascadedStyle.normalize();
    }

    public void read(IDiagramReader in) {
        this.cascadedStyle = (IStyle)in.readProperty("CascadedStyle");
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
    }

    public void removeListener(IStyleChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeProperty(StyleKey key) {
        this.getCascadedStyle().removeProperty(key);
    }

    public void reset() {
        this.getCascadedStyle().reset();
    }

    public void setCascadedStyle(IStyle style) {
        if (this.cascadedStyle == style) {
            return;
        }
        if (this.cascadedStyle != null) {
            this.cascadedStyle.removeListener((IStyleChangeListener)this);
        }
        this.cascadedStyle = style;
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
        this.fireListeners();
    }

    public void setProperty(StyleKey key, Object value) {
        this.getCascadedStyle().setProperty(key, value);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        this.fireListeners(property, newValue);
    }

    public void styleChanged(IStyle changedStyle) {
        this.fireListeners();
    }

    public void write(IDiagramWriter out) {
        if (this.cascadedStyle != null) {
            out.writeProperty("CascadedStyle", (Object)this.cascadedStyle);
        }
    }

    private void fireListeners(StyleKey key, Object value) {
        for (IStyleChangeListener l : new ArrayList(this.listeners)) {
            l.styleChanged(key, value);
        }
    }

    private void fireListeners() {
        for (IStyleChangeListener l : new ArrayList(this.listeners)) {
            l.styleChanged((IStyle)this);
        }
    }

    private String getIllegalArgumentMessagePrefix(StyleKey propertyKey) {
        return "Style property key " + propertyKey + " does not match ";
    }

    public int getMajorVersion() {
        return 0;
    }
}

