/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class Style
implements IPersistent,
IStyle,
IStyleChangeListener {
    protected Map<StyleKey, Object> properties = new HashMap();
    protected IStyle cascadedStyle = null;
    protected List<IStyleChangeListener> listeners = new ArrayList();
    private static final int MAJOR_VERSION = 0;

    public Style(IStyle cascadedStyle) {
        assert (cascadedStyle != null);
        this.cascadedStyle = cascadedStyle;
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
    }

    public void addListener(IStyleChangeListener l) {
        this.listeners.add(l);
    }

    public boolean getBoolean(StyleKey propertyKey) {
        if (this.getProperty(propertyKey) instanceof Boolean) {
            return (Boolean)this.getProperty(propertyKey);
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a boolean value");
    }

    public IStyle getCascadedStyle() {
        return this.cascadedStyle;
    }

    public Color getColor(StyleKey propertyKey) {
        Object value = this.getProperty(propertyKey);
        if (value == null || value instanceof Color) {
            return (Color)value;
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match a color");
    }

    public Font getFont(StyleKey propertyKey) {
        Object value = this.getProperty(propertyKey);
        if (value == null || value instanceof Font) {
            return (Font)value;
        }
        throw new IllegalArgumentException(propertyKey + "Style property key value '" + value + "' does not match a font");
    }

    public int getInteger(StyleKey propertyKey) {
        Object value = this.getProperty(propertyKey);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Style property key " + propertyKey + " does not match an integer value");
    }

    public Set<StyleKey> getLocalKeys() {
        return this.properties.keySet();
    }

    public <T> T getProperty(StyleKey key) {
        if (this.properties.containsKey(key)) {
            return (T)this.properties.get(key);
        }
        return (T)this.cascadedStyle.getProperty(key);
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public boolean isLocal(StyleKey propertyKey) {
        return this.properties.containsKey(propertyKey);
    }

    public void read(IDiagramReader in) {
        this.cascadedStyle = (IStyle)in.readProperty("CascadedStyle");
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
        Map allAtts = in.readAllProperties();
        this.properties = new HashMap(allAtts.size());
        for (Map.Entry e : allAtts.entrySet()) {
            StyleKey stylekey = StyleKey.getInstance((String)((String)e.getKey()));
            if (stylekey == null) continue;
            this.properties.put(stylekey, e.getValue());
        }
    }

    public void removeListener(IStyleChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeProperty(StyleKey key) {
        if (this.properties.remove(key) != null) {
            this.fireListeners(key, null);
        }
    }

    public void reset() {
        this.properties.clear();
        this.fireListeners();
    }

    public void setCascadedStyle(IStyle style) {
        if (style == this) {
            return;
        }
        if (this.cascadedStyle != null) {
            this.cascadedStyle.removeListener((IStyleChangeListener)this);
        }
        this.cascadedStyle = style;
        if (this.cascadedStyle != null) {
            this.cascadedStyle.addListener((IStyleChangeListener)this);
        }
        this.fireListeners();
    }

    public void setProperty(StyleKey key, Object value) {
        if (!key.getType().isInstance(value)) {
            throw new IllegalArgumentException("value must be a " + key.getType() + " for key " + key);
        }
        if (value != null && value.equals(this.properties.get(key))) {
            return;
        }
        this.properties.put(key, value);
        this.fireListeners(key, value);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        this.fireListeners(property, newValue);
    }

    public void styleChanged(IStyle style) {
        this.fireListeners();
    }

    public void write(IDiagramWriter out) {
        if (this.cascadedStyle != null) {
            out.writeProperty("CascadedStyle", (Object)this.cascadedStyle);
        }
        for (Map.Entry e : this.properties.entrySet()) {
            out.writeProperty(((StyleKey)e.getKey()).getId(), e.getValue());
        }
    }

    private void fireListeners(StyleKey key, Object value) {
        for (IStyleChangeListener l : new ArrayList(this.listeners)) {
            l.styleChanged(key, value);
        }
    }

    private void fireListeners() {
        for (IStyleChangeListener l : new ArrayList(this.listeners)) {
            l.styleChanged((IStyle)this);
        }
    }

    public void normalize() {
        for (StyleKey skey : new ArrayList(this.getLocalKeys())) {
            Object localValue = this.getProperty(skey);
            Object cascadedValue = this.getCascadedStyle().getProperty(skey);
            if (localValue instanceof Font) {
                FontData fd1 = ((Font)localValue).getFontData()[0];
                FontData fd2 = ((Font)cascadedValue).getFontData()[0];
                if (fd1.getHeight() != fd2.getHeight() || fd1.getStyle() != fd2.getStyle() || !fd1.getName().equals(fd2.getName())) continue;
                this.removeProperty(skey);
                continue;
            }
            if (!localValue.equals(cascadedValue)) continue;
            this.removeProperty(skey);
        }
    }

    public int getMajorVersion() {
        return 0;
    }
}

