/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StyleKey {
    private String id;
    private Class<?> type;
    private MetaKey metakey;
    private static Map<String, StyleKey> instances = new HashMap();
    private String label;
    private String tooltip;
    private String category;

    public String getId() {
        return this.id;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCategory() {
        return this.category;
    }

    public static StyleKey getInstance(String key) {
        return (StyleKey)instances.get(key);
    }

    public static Collection<StyleKey> getInstances() {
        return instances.values();
    }

    public StyleKey(String id, Class<?> type, String label, String tooltip, String category) {
        this.id = id;
        this.metakey = null;
        this.type = type;
        this.label = label;
        this.tooltip = tooltip;
        this.category = category;
        instances.put(this.id, this);
    }

    public StyleKey(String id, MetaKey metakey, String label, String tooltip, String category) {
        this.id = id;
        this.metakey = metakey;
        this.type = metakey.getType();
        this.label = label;
        this.tooltip = tooltip;
        this.category = category;
        instances.put(this.id, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleKey other = (StyleKey)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public MetaKey getMetakey() {
        return this.metakey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean match(StyleKey k) {
        return this.equals((Object)k) || this.metakey != null && this.metakey.equals(k.metakey);
    }

    public String toString() {
        return this.id;
    }
}

