/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.ui.CoreColorRegistry;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StyleLoader {
    private Map<StyleKey, Object> styleProperties;
    Map<String, Font> fontMap = new HashMap();
    Map<String, Color> colorMap = new HashMap();
    private HashMap<String, String> adminProperties;

    public void load(URL url) {
        this.styleProperties = new HashMap();
        this.adminProperties = new HashMap();
        Properties loadedValues = new Properties();
        try {
            InputStream inputStream = url.openStream();
            loadedValues.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
        }
        for (Object entry : loadedValues.keySet()) {
            String k = (String)entry;
            StyleKey sKey = StyleKey.getInstance((String)k);
            if (sKey != null) {
                try {
                    Object value = this.loadValue(loadedValues, sKey);
                    if (value == null) continue;
                    this.styleProperties.put(sKey, value);
                }
                catch (IOException e) {
                    LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
                }
                continue;
            }
            this.adminProperties.put(k, loadedValues.getProperty(k));
        }
    }

    private Object loadValue(Properties loadedValues, StyleKey sKey) throws IOException {
        String data = loadedValues.getProperty(sKey.getId(), null);
        if (data != null && data.startsWith("$")) {
            data = loadedValues.getProperty(data.trim());
        }
        MetaKey metaKey = sKey.getMetakey();
        if (data != null) {
            Class type = metaKey != null ? metaKey.getType() : sKey.getType();
            try {
                return this.parseData(data, type);
            }
            catch (RuntimeException e) {
                throw new IOException("Parsing of '" + data + "' default value of '" + type.getSimpleName() + "' typed '" + sKey.getId() + "' style key failed: " + e.toString(), e);
            }
        }
        return null;
    }

    private Color makeColor(String data) {
        String[] vals = data.split(" ");
        int red = Integer.valueOf(vals[0]);
        int green = Integer.valueOf(vals[1]);
        int blue = Integer.valueOf(vals[2]);
        RGB rgb = new RGB(red, green, blue);
        return CoreColorRegistry.getColor((RGB)rgb);
    }

    private Object makeFont(String data) {
        String[] vals = data.split(",");
        if (vals.length == 3) {
            String name = vals[0].trim();
            int height = Integer.valueOf(vals[1].trim());
            int style = Integer.valueOf(vals[2].trim());
            FontData fd = new FontData(name, height, style);
            return CoreFontRegistry.getFont((FontData)fd);
        }
        return null;
    }

    private Object parseData(String data, Class<?> type) {
        if (type == Color.class) {
            return this.makeColor(data);
        }
        if (type == Font.class) {
            return this.makeFont(data.trim());
        }
        if (type == Boolean.class) {
            return new Boolean(data);
        }
        if (type == Integer.class) {
            return new Integer(data);
        }
        if (type == String.class) {
            return data;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, data.trim());
        }
        LOG.warning((String)"org.modelio.diagram.styles", (String)"StyleLoader.parseData()  missing converter for '%s'", (Object[])new Object[]{type.getName()});
        return null;
    }

    @Deprecated
    public Map<StyleKey, Object> loadProperties(URL url) {
        this.load(url);
        return this.styleProperties;
    }

    public Map<StyleKey, Object> getStyleProperties() {
        return this.styleProperties;
    }

    public Map<String, String> getAdminProperties() {
        return this.adminProperties;
    }
}

