/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.core;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class StyleWriter {
    private Map<StyleKey, Object> styleProperties;
    private File file;
    private HashMap<String, String> adminProperties;

    public StyleWriter(File file) {
        this.file = file;
    }

    public void save(NamedStyle style) {
        Properties properties = new Properties();
        properties.put("stylename", style.getName());
        if (style.getCascadedStyle() instanceof NamedStyle) {
            properties.put("basestyle", ((NamedStyle)style.getCascadedStyle()).getName());
        }
        for (StyleKey skey : style.getLocalKeys()) {
            String key = skey.getId();
            String value = this.formatValue(skey, style.getProperty(skey));
            properties.put(key, value);
        }
        try {
            this.file.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(this.file);
            properties.store(outputStream, "");
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
        }
    }

    private String formatValue(StyleKey sKey, Object value) {
        Class type = sKey.getType();
        if (type == Color.class) {
            RGB rgb = ((Color)value).getRGB();
            return String.valueOf(rgb.red) + " " + rgb.green + " " + rgb.blue;
        }
        if (type == Font.class) {
            FontData fd = ((Font)value).getFontData()[0];
            return String.valueOf(fd.getName()) + ", " + fd.getHeight() + ", " + fd.getStyle();
        }
        if (type == Boolean.class) {
            return ((Boolean)value).toString();
        }
        if (type == Integer.class) {
            return ((Integer)value).toString();
        }
        if (type == String.class) {
            return (String)value;
        }
        if (type.isEnum()) {
            return value.toString();
        }
        LOG.warning((String)"org.modelio.diagram.styles", (String)"StyleWriter.formatValue(): missing converter for type '%s'", (Object[])new Object[]{type.getName()});
        return "not supported type " + type;
    }
}

