/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.editingsupport;

import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.editingsupport.checkbox.CheckboxLabelProvider;
import com.modeliosoft.modelio.diagram.styles.editingsupport.color.ColorLabelProvider;
import com.modeliosoft.modelio.diagram.styles.editingsupport.combo.EnumComboBoxLabelProvider;
import com.modeliosoft.modelio.diagram.styles.editingsupport.font.FontLabelProvider;
import com.modeliosoft.modelio.diagram.styles.editingsupport.text.TextLabelProvider;
import com.modeliosoft.modelio.diagram.styles.viewer.StyleViewer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class StyleCellLabelProvider
extends ColumnLabelProvider {
    private Map<Class<?>, ColumnLabelProvider> providers = new HashMap();

    public StyleCellLabelProvider(StyleViewer viewer) {
        this.providers.put(Boolean.class, new CheckboxLabelProvider(viewer));
        this.providers.put(String.class, new TextLabelProvider(viewer));
        this.providers.put(Color.class, new ColorLabelProvider(viewer));
        this.providers.put(Integer.class, new TextLabelProvider(viewer));
        this.providers.put(Font.class, new FontLabelProvider(viewer));
        this.providers.put(Enum.class, new EnumComboBoxLabelProvider(viewer));
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof StyleKey) {
            Class stype = ((StyleKey)element).getType();
            ColumnLabelProvider provider = (ColumnLabelProvider)this.providers.get(stype);
            if (provider != null) {
                provider.update(cell);
            } else if (stype.isEnum()) {
                ((ColumnLabelProvider)this.providers.get(Enum.class)).update(cell);
            } else {
                super.update(cell);
            }
        }
    }

    public String getToolTipText(Object element) {
        return super.getToolTipText(element);
    }
}

