/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.editingsupport;

import com.modeliosoft.modelio.core.ui.CoreColorRegistry;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.editingsupport.color.ColorCellEditor2;
import com.modeliosoft.modelio.diagram.styles.editingsupport.combo.EnumComboBoxCellEditor;
import com.modeliosoft.modelio.diagram.styles.editingsupport.font.FontDialogEditor;
import com.modeliosoft.modelio.diagram.styles.editingsupport.number.IntegerCellEditor;
import com.modeliosoft.modelio.diagram.styles.viewer.StyleViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class StylePropertyEditingSupport
extends EditingSupport {
    private final StyleViewer viewer;

    public StylePropertyEditingSupport(StyleViewer viewer) {
        super((ColumnViewer)viewer.getTreeViewer());
        this.viewer = viewer;
    }

    protected boolean canEdit(Object element) {
        return this.viewer.getModel() != null && this.viewer.getModel().isEditable();
    }

    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof StyleKey)) {
            return null;
        }
        Class stype = ((StyleKey)element).getType();
        Tree tree = this.viewer.getTreeViewer().getTree();
        if (stype.equals(Boolean.class)) {
            return new CheckboxCellEditor();
        }
        if (stype.equals(String.class)) {
            return new TextCellEditor((Composite)tree, 4);
        }
        if (stype.equals(Integer.class)) {
            return new IntegerCellEditor((Composite)tree, 4);
        }
        if (stype.equals(Font.class)) {
            return new FontDialogEditor((Composite)tree, 4);
        }
        if (stype.equals(Color.class)) {
            return new ColorCellEditor2((Composite)tree, 4);
        }
        if (stype.isEnum()) {
            return new EnumComboBoxCellEditor((Composite)tree, stype, 4);
        }
        return null;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof StyleKey)) {
            return null;
        }
        IStyle editedStyle = this.viewer.getEditedStyle();
        StyleKey skey = (StyleKey)element;
        Class stype = ((StyleKey)element).getType();
        if (stype.equals(Boolean.class)) {
            return editedStyle.getBoolean(skey);
        }
        if (stype.equals(String.class)) {
            return editedStyle.getProperty(skey);
        }
        if (stype.equals(Integer.class)) {
            return editedStyle.getInteger(skey);
        }
        if (stype.equals(Font.class)) {
            return editedStyle.getProperty(skey);
        }
        if (stype.equals(Color.class)) {
            return editedStyle.getColor(skey).getRGB();
        }
        if (stype.isEnum()) {
            return editedStyle.getProperty(skey);
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof StyleKey)) {
            return;
        }
        IStyle editedStyle = this.viewer.getEditedStyle();
        StyleKey skey = (StyleKey)element;
        Class stype = ((StyleKey)element).getType();
        if (value != null) {
            if (stype.equals(Boolean.class)) {
                editedStyle.setProperty(skey, value);
            }
            if (stype.equals(String.class)) {
                editedStyle.setProperty(skey, value);
            }
            if (stype.equals(Integer.class)) {
                editedStyle.setProperty(skey, value);
            }
            if (stype.equals(Font.class)) {
                editedStyle.setProperty(skey, value);
            }
            if (stype.equals(Color.class)) {
                editedStyle.setProperty(skey, (Object)CoreColorRegistry.getColor((RGB)((RGB)value)));
            }
            if (stype.isEnum()) {
                editedStyle.setProperty(skey, value);
            }
        }
    }
}

