/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.editingsupport.font;

import com.modeliosoft.modelio.diagram.styles.editingsupport.font.FontDialogEditor;
import com.modeliosoft.modelio.diagram.styles.editingsupport.font.FontService;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FontDialogEditor
extends CellEditor {
    private Font value = null;
    private Composite editor;
    private Control contents;
    private Label defaultLabel;
    private Button button;
    private FocusListener buttonFocusListener;

    protected FontDialogEditor(Composite parent) {
        this(parent, 0);
    }

    public FontDialogEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.defaultLabel = new Label(cell, 16384);
        this.defaultLabel.setFont(cell.getFont());
        this.defaultLabel.setBackground(cell.getBackground());
        return this.defaultLabel;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout(this, null));
        this.contents = this.createContents(this.editor);
        this.updateContents((Object)this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setValueValid(true);
        this.defaultLabel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.editor;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
        this.button.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.buttonFocusListener;
    }

    protected void doSetValue(Object value) {
        this.value = (Font)value;
        this.updateContents(value);
    }

    protected Label getDefaultLabel() {
        return this.defaultLabel;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        FontData fData;
        Display display = cellEditorWindow.getDisplay();
        Shell centerShell = new Shell(cellEditorWindow.getShell(), 8);
        centerShell.setLocation(display.getCursorLocation());
        FontDialog ftDialog = new FontDialog(centerShell, 0);
        if (this.value != null) {
            ftDialog.setFontList(this.value.getFontData());
        }
        if ((fData = ftDialog.open()) != null) {
            return fData;
        }
        return null;
    }

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value instanceof Font ? FontService.getFontLabel((Font)((Font)value)) : value.toString();
        }
        this.defaultLabel.setText(text);
    }

    static /* synthetic */ Button access$0(FontDialogEditor fontDialogEditor) {
        return fontDialogEditor.button;
    }

    static /* synthetic */ Control access$1(FontDialogEditor fontDialogEditor) {
        return fontDialogEditor.contents;
    }

    static /* synthetic */ void access$2(FontDialogEditor fontDialogEditor) {
        fontDialogEditor.fireCancelEditor();
    }

    static /* synthetic */ FocusListener access$3(FontDialogEditor fontDialogEditor) {
        return fontDialogEditor.getButtonFocusListener();
    }

    static /* synthetic */ Composite access$4(FontDialogEditor fontDialogEditor) {
        return fontDialogEditor.editor;
    }

    static /* synthetic */ boolean access$5(FontDialogEditor fontDialogEditor, Object object) {
        return fontDialogEditor.isCorrect(object);
    }

    static /* synthetic */ void access$6(FontDialogEditor fontDialogEditor) {
        fontDialogEditor.markDirty();
    }

    static /* synthetic */ void access$7(FontDialogEditor fontDialogEditor, String string) {
        fontDialogEditor.setErrorMessage(string);
    }

    static /* synthetic */ void access$8(FontDialogEditor fontDialogEditor) {
        fontDialogEditor.fireApplyEditorValue();
    }

    static /* synthetic */ void access$9(FontDialogEditor fontDialogEditor) {
        fontDialogEditor.focusLost();
    }
}

