/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.editingsupport.key;

import com.modeliosoft.modelio.core.ui.CoreColorRegistry;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.viewer.StyleViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class KeyLabelProvider
extends StyledCellLabelProvider {
    private StyleViewer viewer;
    private static final RGB heritedColor = new RGB(64, 64, 64);
    private static final RGB localColor = new RGB(0, 0, 0);
    private Font boldFont;

    public KeyLabelProvider(StyleViewer viewer) {
        this.viewer = viewer;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof String) {
            String cellText = (String)element;
            cell.setText(cellText);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = cellText.length();
            styleRange.foreground = CoreColorRegistry.getColor((RGB)heritedColor);
            styleRange.font = null;
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getTreeViewer().getContentProvider();
            Object[] objectArray = contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                StyleKey skey = (StyleKey)obj;
                if (this.viewer.getEditedStyle().isLocal(skey)) {
                    styleRange.foreground = CoreColorRegistry.getColor((RGB)localColor);
                    styleRange.font = this.getBoldFont(cell.getFont());
                    break;
                }
                ++n2;
            }
            cell.setStyleRanges(new StyleRange[]{styleRange});
        } else {
            StyleKey skey = (StyleKey)cell.getElement();
            String cellText = skey.getLabel();
            cell.setText(cellText);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = cellText.length();
            if (this.viewer.getEditedStyle().isLocal(skey)) {
                styleRange.foreground = CoreColorRegistry.getColor((RGB)localColor);
                styleRange.font = this.getBoldFont(cell.getFont());
            } else {
                styleRange.foreground = CoreColorRegistry.getColor((RGB)heritedColor);
                styleRange.font = null;
            }
            cell.setStyleRanges(new StyleRange[]{styleRange});
        }
    }

    private Font getBoldFont(Font font) {
        if (this.boldFont == null) {
            this.boldFont = CoreFontRegistry.getModifiedFont((Font)font, (int)1);
        }
        return this.boldFont;
    }

    public void dispose() {
        this.boldFont = null;
        super.dispose();
    }
}

