/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.manager;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.styles.core.FactoryStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.manager.StyleEditorDialog;
import com.modeliosoft.modelio.diagram.styles.manager.StyleModelProvider;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;
import com.modeliosoft.modelio.diagram.styles.ui.Messages;
import com.modeliosoft.modelio.diagram.styles.viewer.StyleViewer;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class StyleEditorDialog
extends ModelioDialog {
    StyleViewer viewer;
    private StyleModelProvider model;
    private SashForm mainSash;
    private Label descriptionText;
    private Button saveButton;
    private Button normButton;
    private Button restoreButton;
    private Font titleFont;
    private Label title;

    public StyleEditorDialog(Shell parentShell) {
        super(parentShell);
        NamedStyle editedStyle = new NamedStyle("new style", (IStyle)FactoryStyle.getInstance());
        this.model = new StyleModelProvider((IStyle)editedStyle, null, true);
        this.setBlockOnOpen(false);
    }

    public Control createContentArea(Composite parent) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = parent.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight((int)((double)data.getHeight() * 1.4));
            data.setStyle(data.getStyle() | 1);
            ++n2;
        }
        this.titleFont = CoreFontRegistry.getFont((FontData[])fontData);
        this.mainSash = new SashForm(parent, 256);
        this.mainSash.setLayout((Layout)new FillLayout());
        this.mainSash.setFont(parent.getFont());
        this.mainSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createStyleTreeViewer((Composite)this.mainSash);
        this.createStyleEditorPanel((Composite)this.mainSash);
        this.viewer.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new StyleViewerSelectionChangedListener(this, this));
        this.mainSash.setWeights(new int[]{20, 80});
        return this.mainSash;
    }

    private StyleViewer createStyleViewer(Composite parent, StyleModelProvider modelProvider) {
        return new StyleViewer(parent, modelProvider);
    }

    public void init() {
        this.setTitle(Messages.getString((String)"EditStylesDialog.SubTitle"));
        this.setMessage(Messages.getString((String)"EditStylesDialog.Message"));
        this.getShell().setText(Messages.getString((String)"EditStylesDialog.Title"));
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    public void setEditedStyle(IStyle editedStyle) {
        StyleModelProvider styleModelProvider = this.model = editedStyle != null ? new StyleModelProvider(editedStyle, null, true) : null;
        if (editedStyle != null) {
            this.title.setText(Messages.getMessage((String)"EditStylesDialog.CurrentStyle", (String[])new String[]{((NamedStyle)editedStyle).getName()}));
        } else {
            this.title.setText(" ");
        }
        if (this.viewer != null) {
            Object[] expandedCategories = this.viewer.getTreeViewer().getExpandedElements();
            this.viewer.setModel(this.model);
            this.viewer.getTreeViewer().getTree().setRedraw(false);
            Object[] objectArray = expandedCategories;
            int n = expandedCategories.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.viewer.getTreeViewer().setExpandedState(o, true);
                ++n2;
            }
            this.viewer.getTreeViewer().getTree().setRedraw(true);
        }
    }

    public boolean close() {
        this.setEditedStyle(null);
        this.titleFont = null;
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(800, 800);
    }

    protected void styleViewerSelectionChanged(List<Object> selectedElements) {
        boolean onlyStyleKeys = true;
        for (Object o : selectedElements) {
            onlyStyleKeys &= o instanceof StyleKey;
        }
        if (onlyStyleKeys) {
            if (selectedElements.isEmpty()) {
                this.restoreButton.setEnabled(false);
                this.descriptionText.setText("");
            } else if (selectedElements.size() == 1) {
                this.restoreButton.setEnabled(true);
                this.descriptionText.setText(((StyleKey)selectedElements.get(0)).getTooltip());
            } else {
                this.restoreButton.setEnabled(true);
                this.descriptionText.setText("");
            }
        } else {
            this.restoreButton.setEnabled(false);
            this.descriptionText.setText("");
        }
    }

    private Composite createStyleEditorPanel(Composite parent) {
        Composite styleEditorPanel = new Composite(parent, 2048);
        styleEditorPanel.setLayout((Layout)new FormLayout());
        this.title = new Label(styleEditorPanel, 0);
        this.title.setText("");
        this.title.setFont(this.titleFont);
        FormData fData0 = new FormData();
        fData0.top = new FormAttachment(0, 10);
        fData0.left = new FormAttachment(0, 2);
        fData0.right = new FormAttachment(100, -2);
        this.title.setLayoutData((Object)fData0);
        SashForm sash = new SashForm(styleEditorPanel, 2560);
        FormData fData1 = new FormData();
        fData1.top = new FormAttachment((Control)this.title, 10);
        fData1.bottom = new FormAttachment(100, -30);
        fData1.left = new FormAttachment(0, 2);
        fData1.right = new FormAttachment(100, -2);
        sash.setLayoutData((Object)fData1);
        this.viewer = this.createStyleViewer((Composite)sash, this.model);
        this.descriptionText = new Label((Composite)sash, 576);
        this.descriptionText.setForeground(UIColor.LABEL_TIP_FG);
        sash.setWeights(new int[]{80, 20});
        Composite editionToolbar = this.createStyleEditorButtons(styleEditorPanel);
        FormData fData2 = new FormData();
        fData2.top = new FormAttachment((Control)sash, 2);
        fData2.bottom = new FormAttachment(100, -2);
        fData2.left = new FormAttachment(0, 5);
        fData2.right = new FormAttachment(100, -2);
        editionToolbar.setLayoutData((Object)fData2);
        return styleEditorPanel;
    }

    private TreeViewer createStyleTreeViewer(Composite parent) {
        TreeViewer treeView = new TreeViewer(parent, 2048);
        treeView.setContentProvider((IContentProvider)new StyleTreeContentProvider(null));
        treeView.setLabelProvider((IBaseLabelProvider)new StyleTreeLabelProvider(this));
        treeView.setInput((Object)DiagramStyles.getInstance().getStyleManager());
        treeView.addSelectionChangedListener((ISelectionChangedListener)new StyleTreeSelectionChangedListener(this, this));
        treeView.setAutoExpandLevel(2);
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        treeView.addDragSupport(2, transferTypes, (DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
        treeView.addDropSupport(2, transferTypes, (DropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        3 createStyleAction = new /* Unavailable Anonymous Inner Class!! */;
        createStyleAction.setText(Messages.getString((String)"EditStylesDialog.DeriveCommand"));
        menuMgr.add((IAction)createStyleAction);
        Menu menu = menuMgr.createContextMenu((Control)treeView.getTree());
        treeView.getTree().setMenu(menu);
        return treeView;
    }

    private Composite createStyleEditorButtons(Composite styleEditorPanel) {
        Composite editionToolbar = new Composite(styleEditorPanel, 0);
        editionToolbar.setLayout((Layout)new RowLayout(256));
        this.saveButton = new Button(editionToolbar, 8);
        this.saveButton.setText(Messages.getString((String)"EditStylesDialog.SaveButton"));
        this.saveButton.setToolTipText("Save the current settings for the style");
        this.saveButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.normButton = new Button(editionToolbar, 8);
        this.normButton.setText(Messages.getString((String)"EditStylesDialog.NormalizeButton"));
        this.normButton.setToolTipText("Normalize the style definitions. Remove useless local properties definitions.");
        this.normButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.restoreButton = new Button(editionToolbar, 8);
        this.restoreButton.setText(Messages.getString((String)"EditStylesDialog.RestoreButton"));
        this.restoreButton.setToolTipText("Restore the selected values to their inherited value");
        this.restoreButton.addSelectionListener((SelectionListener)new RestoreButtonSelectionListener(this));
        return editionToolbar;
    }
}

