/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.manager;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.styles.core.FactoryStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleLoader;
import com.modeliosoft.modelio.diagram.styles.core.StyleWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StyleManager {
    private HashMap<String, NamedStyle> styles = new HashMap();
    private HashMap<String, File> files = new HashMap();

    public List<String> getAvailableStyles() {
        return new ArrayList<String>(this.styles.keySet());
    }

    public NamedStyle getStyle(String name) {
        return (NamedStyle)this.styles.get(name);
    }

    public NamedStyle createStyle(File projectSpacePath, String name) {
        if (this.getStyle(name) != null) {
            return this.getStyle(name);
        }
        File projectStyleDir = new File(projectSpacePath, ".config/styles");
        if (!projectStyleDir.exists()) {
            projectStyleDir.mkdirs();
        }
        File newStyleFile = new File(projectStyleDir, String.valueOf(name) + ".style");
        NamedStyle newStyle = new NamedStyle(name, (IStyle)FactoryStyle.getInstance());
        this.registerStyle(name, newStyle, newStyleFile);
        this.save(newStyle);
        return newStyle;
    }

    protected void registerStyle(String name, NamedStyle style, File storage) {
        this.styles.put(name, style);
        this.files.put(name, storage);
    }

    public void reset(List<File> stylesDir) {
        this.styles = new HashMap();
        this.files = new HashMap();
        HashMap<String, String> deferedBindings = new HashMap<String, String>();
        for (File dir : stylesDir) {
            File[] styleFiles;
            if (!dir.isDirectory()) continue;
            File[] fileArray = styleFiles = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            int n = styleFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                StyleLoader loader = new StyleLoader();
                try {
                    NamedStyle namedStyle;
                    String cascadedStyleName;
                    loader.load(f.toURI().toURL());
                    String styleName = (String)loader.getAdminProperties().get("stylename");
                    if (styleName == null) {
                        styleName = f.getName();
                    }
                    if ((cascadedStyleName = (String)loader.getAdminProperties().get("basestyle")) == null) {
                        cascadedStyleName = "default";
                    }
                    if (this.getStyle(cascadedStyleName) != null) {
                        namedStyle = new NamedStyle(styleName, loader.getStyleProperties(), (IStyle)this.getStyle(cascadedStyleName));
                        this.registerStyle(styleName, namedStyle, f);
                    } else {
                        namedStyle = new NamedStyle(styleName, loader.getStyleProperties(), (IStyle)FactoryStyle.getInstance());
                        this.registerStyle(styleName, namedStyle, f);
                        deferedBindings.put(styleName, cascadedStyleName);
                    }
                }
                catch (MalformedURLException e) {
                    LOG.error((String)"org.modelio.diagram.styles", (Throwable)e);
                }
                ++n2;
            }
        }
        NamedStyle defaultStyle = this.getStyle("default");
        for (String styleName : deferedBindings.keySet()) {
            if (styleName.equals("default")) continue;
            NamedStyle style = this.getStyle(styleName);
            NamedStyle cascadeStyle = this.getStyle((String)deferedBindings.get(styleName));
            if (cascadeStyle != null) {
                style.setCascadedStyle((IStyle)cascadeStyle);
                continue;
            }
            style.setCascadedStyle((IStyle)defaultStyle);
            LOG.error((String)"org.modelio.diagram.styles", (String)"Cannot set cascade style for '%s' to '%s', replaced by 'default'", (Object[])new Object[]{styleName, cascadeStyle});
        }
    }

    public void save(NamedStyle style) {
        if (this.styles.containsValue(style)) {
            NamedStyle namedStyle = style;
            File file = (File)this.files.get(namedStyle.getName());
            StyleWriter sw = new StyleWriter(file);
            sw.save(namedStyle);
        }
    }

    public void normalize(NamedStyle style) {
        if (this.styles.containsValue(style)) {
            NamedStyle s = style;
            for (StyleKey skey : s.getLocalKeys()) {
                Object cascadedValue;
                Object localValue = s.getProperty(skey);
                if (!localValue.equals(cascadedValue = s.getCascadedStyle().getProperty(skey))) continue;
                s.removeProperty(skey);
            }
        }
    }

    public NamedStyle getDefaultStyle() {
        return this.getStyle("default");
    }

    public NamedStyle createStyle(File projectSpacePath, String name, String parentStyleName) {
        NamedStyle newStyle = this.createStyle(projectSpacePath, name);
        if (newStyle != null && parentStyleName != null) {
            NamedStyle parentStyle = this.getStyle(parentStyleName);
            newStyle.setCascadedStyle((IStyle)(parentStyle != null ? parentStyle : this.getDefaultStyle()));
            this.save(newStyle);
        }
        return newStyle;
    }

    public NamedStyle createStyle(File projectSpacePath, String name, String parentStyleName, URL styleData) {
        NamedStyle newStyle = this.createStyle(projectSpacePath, name, parentStyleName);
        StyleLoader loader = new StyleLoader();
        loader.load(styleData);
        for (StyleKey key : loader.getStyleProperties().keySet()) {
            newStyle.setProperty(key, loader.getStyleProperties().get(key));
        }
        this.save(newStyle);
        return newStyle;
    }
}

