/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.manager;

import com.modeliosoft.modelio.core.utils.MultiHashMap;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StyleModelProvider
implements ITreeContentProvider {
    private IStyle styleData;
    private Collection<StyleKey> keyfilter;
    private final MultiHashMap<String, StyleKey> cache = new MultiHashMap();
    private static final Object[] NO_OBJECTS = new Object[0];
    private boolean isEditable;

    public IStyle getStyleData() {
        return this.styleData;
    }

    public Collection<StyleKey> getKeyfilter() {
        return this.keyfilter;
    }

    public Object[] getElements(Object inputElement) {
        if (this.styleData == null) {
            return NO_OBJECTS;
        }
        ArrayList displayedKeys = this.keyfilter != null ? new ArrayList(this.keyfilter) : new ArrayList(StyleKey.getInstances());
        this.cache.clear();
        for (StyleKey skey : displayedKeys) {
            this.cache.putValue((Object)skey.getCategory(), (Object)skey);
        }
        if (this.cache.keySet().size() == 1) {
            return this.cache.getList((Object)((String)this.cache.keySet().iterator().next())).toArray();
        }
        ArrayList categories = new ArrayList(this.cache.keySet());
        Collections.sort(categories);
        return categories.toArray();
    }

    public void dispose() {
        this.cache.clear();
        this.styleData = null;
        this.keyfilter = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }

    public StyleModelProvider(IStyle styleData, Collection<StyleKey> keyfilter, boolean isEditable) {
        this.styleData = styleData;
        this.keyfilter = keyfilter;
        this.isEditable = isEditable;
    }

    public StyleModelProvider(IStyle editedStyle) {
        this(editedStyle, null, false);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof StyleKey) {
            return null;
        }
        if (parentElement instanceof String) {
            return this.cache.getList((Object)((String)parentElement)).toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof StyleKey) {
            return false;
        }
        return element instanceof String && this.cache.containsKey(element);
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

