/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.plugin;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.styles.Activator;
import com.modeliosoft.modelio.diagram.styles.manager.StyleManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class DiagramStyles {
    private static final DiagramStyles INSTANCE = new DiagramStyles();
    private StyleManager styleManager = new StyleManager();
    public static final String PROJECT_STYLE_SUBDIR = ".config/styles";
    private IModelingSession modelingSession;
    public static final String STYLE_FILE_EXTENSION = ".style";
    public static final String DEFAULT_STYLE_NAME = "default";
    public static final String PLUGIN_ID = "org.modelio.diagram.styles";

    private DiagramStyles() {
    }

    public static DiagramStyles getInstance() {
        return INSTANCE;
    }

    public void sessionClosed(IModelingSession modelingSession) {
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.configureProjectStyleDirectory();
        ArrayList<File> stylesDir = new ArrayList<File>();
        stylesDir.add(new File(this.modelingSession.getProjectSpacePath(), PROJECT_STYLE_SUBDIR));
        this.styleManager.reset(stylesDir);
    }

    public StyleManager getStyleManager() {
        return this.styleManager;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    private void configureProjectStyleDirectory() {
        File defaultStyleFile;
        assert (this.modelingSession != null);
        File projectStyleDir = new File(this.modelingSession.getProjectSpacePath(), PROJECT_STYLE_SUBDIR);
        if (!projectStyleDir.exists()) {
            projectStyleDir.mkdirs();
        }
        if (!(defaultStyleFile = new File(projectStyleDir, "default.style")).exists()) {
            this.dropStyleFile(defaultStyleFile, new Path("res/default.style"));
        }
    }

    private void dropStyleFile(File styleFile, Path path) {
        Bundle bundle = Activator.getDefault().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            int len;
            InputStream sourceStream = url.openStream();
            FileOutputStream out = new FileOutputStream(styleFile);
            byte[] buf = new byte[1024];
            while ((len = sourceStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            sourceStream.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOG.error((String)PLUGIN_ID, (Throwable)e);
        }
    }
}

