/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.styles.viewer;

import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.editingsupport.StyleCellLabelProvider;
import com.modeliosoft.modelio.diagram.styles.editingsupport.StylePropertyEditingSupport;
import com.modeliosoft.modelio.diagram.styles.editingsupport.key.KeyLabelProvider;
import com.modeliosoft.modelio.diagram.styles.manager.StyleModelProvider;
import com.modeliosoft.modelio.diagram.styles.ui.Messages;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class StyleViewer
implements IStyleChangeListener {
    private StyleModelProvider model;
    private final StyleModelProvider emptyModel = new StyleModelProvider(null);
    private TreeViewer treeViewer;

    public StyleViewer(Composite parent, StyleModelProvider model) {
        StyleModelProvider initialModel;
        this.model = initialModel = model != null ? model : this.emptyModel;
        this.treeViewer = new TreeViewer(parent, 101122);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.model);
        this.treeViewer.setInput((Object)this.model);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.createColumns(this);
        this.treeViewer.refresh();
    }

    public void setLayoutData(Object layoutData) {
        this.treeViewer.getTree().setLayoutData(layoutData);
    }

    private void createColumns(StyleViewer viewer) {
        String[] columnTitles = new String[]{Messages.getString((String)"StylesViewer.Property"), Messages.getString((String)"StylesViewer.Value")};
        int[] columnInitialWidths = new int[]{200, 100};
        TreeViewerColumn col1 = this.createTreeViewerColumn(viewer, columnTitles[0], columnInitialWidths[0]);
        col1.setLabelProvider((CellLabelProvider)new KeyLabelProvider(viewer));
        TreeViewerColumn col2 = this.createTreeViewerColumn(viewer, columnTitles[1], columnInitialWidths[1]);
        col2.setLabelProvider((CellLabelProvider)new StyleCellLabelProvider(viewer));
        col2.setEditingSupport((EditingSupport)new StylePropertyEditingSupport(viewer));
        this.treeViewer.setContentProvider((IContentProvider)this.model);
    }

    private TreeViewerColumn createTreeViewerColumn(StyleViewer theViewer, String title, int bound) {
        TreeViewerColumn column = new TreeViewerColumn(theViewer.treeViewer, 0);
        column.getColumn().setText(title);
        column.getColumn().setWidth(bound);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        return column;
    }

    public IStyle getEditedStyle() {
        return this.model.getStyleData();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setModel(StyleModelProvider model) {
        if (this.model != null && this.model.getStyleData() != null) {
            this.model.getStyleData().removeListener((IStyleChangeListener)this);
        }
        if (model == null) {
            this.model = this.emptyModel;
            this.treeViewer.setContentProvider((IContentProvider)this.model);
            this.treeViewer.setInput((Object)this.model);
        } else {
            this.model = model;
            this.treeViewer.setContentProvider((IContentProvider)this.model);
            this.treeViewer.setInput((Object)this.model);
            this.model.getStyleData().addListener((IStyleChangeListener)this);
        }
        this.treeViewer.refresh();
    }

    public void styleChanged(IStyle changedStyle) {
        this.treeViewer.getTree().deselectAll();
        this.treeViewer.refresh(true);
        this.treeViewer.getTree().redraw();
    }

    public void styleChanged(StyleKey property, Object newValue) {
        this.treeViewer.getTree().deselectAll();
        this.treeViewer.refresh(true);
        this.treeViewer.getTree().redraw();
    }

    public StyleModelProvider getModel() {
        return this.model;
    }
}

