/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.constraintChooser;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserContentProvider;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserDriver;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserLabelProvider;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserModel;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserSorter;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintTypeChooserAdapter;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class ConstraintChooserDriver
implements IElementChooserDriver {
    IModelingSession session;
    private IConstraint createdConstraint;
    private IModelElement element;
    private String initialContent;
    private ConstraintChooserModel leftModel;
    private TreeViewer leftViewer;
    private ConstraintChooserSelectionListener constraintSelectionListener = null;
    private Object selectedAnnotationAdapter = null;

    public ConstraintChooserDriver(IModelingSession session, Object selectedAnnotationAdapter) {
        this.session = session;
        this.selectedAnnotationAdapter = selectedAnnotationAdapter;
        this.initialContent = EditionNotes.I18N.getString("EnterConstraintBody");
        this.constraintSelectionListener = new ConstraintChooserSelectionListener(this, null);
    }

    public StructuredViewer createViewer(Composite parent) {
        this.leftViewer = new TreeViewer(parent, 2050);
        this.leftViewer.setContentProvider((IContentProvider)new ConstraintChooserContentProvider());
        this.leftViewer.setLabelProvider((IBaseLabelProvider)new ConstraintChooserLabelProvider(this.session));
        this.leftViewer.setSorter((ViewerSorter)new ConstraintChooserSorter());
        this.leftViewer.setAutoExpandLevel(-1);
        this.leftViewer.addSelectionChangedListener((ISelectionChangedListener)this.constraintSelectionListener);
        return this.leftViewer;
    }

    public IConstraint getCreatedConstraint() {
        return this.createdConstraint;
    }

    public String getLeftLabel() {
        return EditionNotes.I18N.getString("AddNoteLeftLabel");
    }

    public String getTitle() {
        return EditionNotes.I18N.getString("ConstraintChooserTitle");
    }

    public void init(IElement element) {
        if (element instanceof IModelElement) {
            this.element = (IModelElement)element;
            this.leftModel = new ConstraintChooserModel(this.session);
            this.leftViewer.setInput((Object)this.leftModel);
            this.setExpandedState();
        }
    }

    public void performCancel() {
    }

    public void performFinish(StructuredViewer leftViewer, List<Object> selection) {
        ITransactionManager manager = this.session.getTransactionManager();
        ITransaction transaction = manager.createTransaction(EditionNotes.I18N.getString("AddNote"));
        try {
            try {
                IModelFactory factory = this.session.getModelFactory();
                for (Object obj : selection) {
                    ConstraintTypeChooserAdapter adapter = (ConstraintTypeChooserAdapter)obj;
                    IStereotype stereotype = adapter.getStereotype();
                    this.createdConstraint = factory.createConstraint();
                    this.createdConstraint.setName("");
                    if (stereotype != null) {
                        this.createdConstraint.addExtension(stereotype);
                    }
                    this.createdConstraint.setBody(this.initialContent);
                    this.element.addConstraintDefinition(this.createdConstraint);
                }
                manager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    manager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                manager.rollback(transaction);
            }
        }
    }

    public String getMessage() {
        return EditionNotes.I18N.getString("ConstraintChooserMessage");
    }

    public String getShellTitle() {
        return EditionNotes.I18N.getString("ConstraintChooserShellTitle");
    }

    protected void finalize() throws Throwable {
        this.leftViewer.removeSelectionChangedListener((ISelectionChangedListener)this.constraintSelectionListener);
        super.finalize();
    }

    private void setExpandedState() {
    }

    static /* synthetic */ TreeViewer access$0(ConstraintChooserDriver constraintChooserDriver) {
        return constraintChooserDriver.leftViewer;
    }
}

