/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.constraintChooser;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.ui.EditionUI;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintMdacAdapter;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintTypeChooserAdapter;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConstraintChooserLabelProvider
extends LabelProvider {
    private IModelingSession modelingSession = null;

    public Image getImage(Object element) {
        if (element instanceof ConstraintMdacAdapter) {
            ConstraintMdacAdapter adapter = (ConstraintMdacAdapter)element;
            IModule module = adapter.getMdac();
            return this.getModuleImage(module);
        }
        if (element instanceof ConstraintTypeChooserAdapter) {
            IModule module;
            Image image = null;
            ConstraintTypeChooserAdapter adapter = (ConstraintTypeChooserAdapter)element;
            IStereotype stereotype = adapter.getStereotype();
            IMetamodelExtensions metamodelExtensions = this.modelingSession.getModel().getMetamodelExtensions();
            if (stereotype != null && (module = metamodelExtensions.getModule(stereotype)) != null) {
                IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(module);
                image = mdac.getImage(stereotype, IMdac.ImageType.ICON);
            }
            if (image == null) {
                image = StandardImageService.getMetaclassImage(IConstraint.class);
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ConstraintMdacAdapter) {
            IMdac module;
            IMdacRegistry mdacRegistry = null;
            ConstraintMdacAdapter adapter = (ConstraintMdacAdapter)element;
            if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(adapter.getMdac())) != null) {
                return module.getLabel();
            }
            return adapter.getMdac().getName();
        }
        if (element instanceof ConstraintTypeChooserAdapter) {
            StringBuffer constraintTypeLabel = new StringBuffer();
            ConstraintTypeChooserAdapter adapter = (ConstraintTypeChooserAdapter)element;
            IStereotype stereotype = adapter.getStereotype();
            if (stereotype == null) {
                constraintTypeLabel.append(EditionNotes.I18N.getString("Constraint"));
            } else {
                String label = adapter.getStereotype().getLabel();
                if (!"".equals(label)) {
                    constraintTypeLabel.append(label);
                } else {
                    constraintTypeLabel.append(stereotype.getName());
                }
            }
            return constraintTypeLabel.toString();
        }
        return element.toString();
    }

    public ConstraintChooserLabelProvider(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
    }

    private Image getModuleImage(IModule moduleModel) {
        ImageDescriptor defaultModuleDescriptor;
        IMdac module;
        IMdacRegistry mdacRegistry = null;
        String key = "MDAC." + moduleModel.getName();
        Image moduleImage = StandardImageService.getImage((String)key);
        if (moduleImage != null) {
            return moduleImage;
        }
        if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(moduleModel)) != null) {
            ImageDescriptor moduleImageDescriptor = module.getMdacImageDescriptor();
            if (moduleImageDescriptor != null) {
                StandardImageService.declareImage((String)key, (ImageDescriptor)moduleImageDescriptor);
                moduleImage = StandardImageService.getImage((String)key);
            }
            if (moduleImage != null) {
                return moduleImage;
            }
        }
        if ((moduleImage = StandardImageService.getImage((String)"DefaultModuleImage")) == null && (defaultModuleDescriptor = EditionUI.getSharedImages().getImageDescriptor("edition.mdacomponent")) != null) {
            StandardImageService.declareImage((String)"DefaultModuleImage", (ImageDescriptor)defaultModuleDescriptor);
            moduleImage = StandardImageService.getImage((String)"DefaultModuleImage");
        }
        return moduleImage;
    }
}

