/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.constraintChooser;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintMdacAdapter;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintTypeChooserAdapter;
import java.util.HashMap;
import java.util.Map;

public class ConstraintChooserModel {
    private IModelingSession session;
    private Map<IModule, ConstraintMdacAdapter> mdacAdapters;
    private ConstraintTypeChooserAdapter noTypeAdapter;

    public ConstraintChooserModel(IModelingSession session) {
        this.session = session;
        this.mdacAdapters = new HashMap();
        this.noTypeAdapter = new ConstraintTypeChooserAdapter(null, null);
        this.init();
    }

    private void init() {
        IMetamodelExtensions extensions = this.session.getModel().getMetamodelExtensions();
        ObList stereotypes = extensions.getStereotypes(IConstraint.class);
        for (IStereotype stereotype : stereotypes) {
            IModule module = extensions.getModule(stereotype);
            if (module == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addConstraintType(module, stereotype);
        }
    }

    private ConstraintTypeChooserAdapter addConstraintType(IModule mdac, IStereotype stereotype) {
        ConstraintMdacAdapter adapter = (ConstraintMdacAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new ConstraintMdacAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        return adapter.addStereotype(stereotype);
    }

    public Map<IModule, ConstraintMdacAdapter> getMdacAdapters() {
        return this.mdacAdapters;
    }

    ConstraintTypeChooserAdapter getNoTypeAdapter() {
        return this.noTypeAdapter;
    }
}

