/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.dnd;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class NoteDragListener
implements DragSourceListener {
    private TreeViewer listOfNotes;

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        if (ModelElementTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<IElement> selectedElements = new ArrayList<IElement>();
            IAdaptable adapter = null;
            ISelection selection = this.listOfNotes.getSelection();
            if (selection instanceof IStructuredSelection) {
                List selectedObjects = ((IStructuredSelection)selection).toList();
                for (Object obj : selectedObjects) {
                    adapter = (IAdaptable)obj;
                    selectedElements.add((IElement)adapter.getAdapter(IElement.class));
                }
                event.data = selectedElements.toArray(new IElement[selectedElements.size()]);
            } else {
                event.doit = false;
            }
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<IElement> selectedElements = new ArrayList<IElement>();
            IAdaptable adapter = null;
            ISelection selection = this.listOfNotes.getSelection();
            if (selection instanceof IStructuredSelection) {
                List selectedObjects = ((IStructuredSelection)selection).toList();
                for (Object obj : selectedObjects) {
                    adapter = (IAdaptable)obj;
                    selectedElements.add((IElement)adapter.getAdapter(IElement.class));
                }
                PasteElementObject.PasteType type = null;
                if (event.detail == 1) {
                    type = PasteElementObject.PasteType.COPY;
                } else if (event.detail == 2) {
                    type = PasteElementObject.PasteType.CUT;
                }
                PasteElementObject pasteObject = new PasteElementObject(type);
                for (IElement element : selectedElements) {
                    pasteObject.addTransferedItems(new TransferItem(element, element.getCompositionOwner()));
                }
                byte[] data = PasteElementTransfer.getInstance().toByteArray(pasteObject);
                event.data = new PluginTransferData("com.modeliosoft.modelio.edition.dnd.noteDrop", data);
            } else {
                event.doit = false;
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.listOfNotes.getSelection();
        LocalSelectionTransfer.getTransfer().setSelection(selection);
    }

    public NoteDragListener(TreeViewer listOfNotes) {
        this.listOfNotes = listOfNotes;
    }

    public TreeViewer getListOfNotes() {
        return this.listOfNotes;
    }
}

