/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.edition.notes.constraintChooser.ConstraintChooserDriver;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.mda.services.elementChooser.ElementChooserDlg;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddConstraintHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        NotesView view = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (view != null) {
            ConstraintChooserDriver driver = new ConstraintChooserDriver(EditionNotes.getInstance().getSession(), null);
            IModelElement currentElement = view.getCurrentElement();
            ElementChooserDlg dialog = new ElementChooserDlg(shell, (IElementChooserDriver)driver, currentElement);
            dialog.setBlockOnOpen(true);
            dialog.open();
            IConstraint contraint = driver.getCreatedConstraint();
            if (contraint != null) {
                this.selectConstraint(contraint);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        NotesView notesView = this.getNotesView();
        if (notesView == null) {
            return false;
        }
        IModelElement element = notesView.getCurrentElement();
        if (element == null) {
            return false;
        }
        return element.getElementStatus().isModifiable();
    }

    public boolean isHandled() {
        return true;
    }

    private void selectConstraint(IConstraint constraint) {
        NotesView notesView = this.getNotesView();
        if (notesView != null) {
            notesView.setCurrentElement((IElement)constraint);
        }
    }

    private NotesView getNotesView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (NotesView)page.findViewReference("com.modeliosoft.modelio.edition.notes.NotesViewID").getView(false);
    }
}

