/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentCreator;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.ui.richnote.PromptRichNoteDescriptorDlg;
import com.modeliosoft.modelio.core.ui.richnote.RichNoteDescriptor;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddExternDocumentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NotesView view = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (view != null) {
            RichNoteDescriptor richNoteDescriptor;
            IExternDocument richNote;
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            IModelElement currentElement = view.getCurrentElement();
            PromptRichNoteDescriptorDlg dialog = new PromptRichNoteDescriptorDlg(shell, new RichNoteDescriptor(currentElement), EditionNotes.getInstance().getSession());
            dialog.setBlockOnOpen(true);
            int ret = dialog.open();
            if (ret == 0 && (richNote = this.createRichNote(currentElement, richNoteDescriptor = dialog.getRichNoteDescriptor())) != null) {
                this.selectDoc(richNote);
                this.openDoc(richNote);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        NotesView notesView = this.getNotesView();
        if (notesView == null) {
            return false;
        }
        IModelElement element = notesView.getCurrentElement();
        if (element == null) {
            return false;
        }
        return element.getElementStatus().isModifiable();
    }

    public boolean isHandled() {
        return true;
    }

    private IExternDocument createRichNote(IModelElement modelElement, RichNoteDescriptor model) {
        IModelingSession session = EditionNotes.getInstance().getSession();
        ITransactionManager manager = session.getTransactionManager();
        ITransaction transaction = manager.createTransaction(EditionNotes.I18N.getString("AddDocument"));
        try {
            IModelFactory factory = session.getModelFactory();
            IExternDocument doc = (IExternDocument)factory.createElement("ExternDocument");
            doc.setSubject(modelElement);
            doc.setName(model.getName());
            doc.setType(model.getDocumentType());
            doc.setMimeType(model.getChosenMimeType());
            doc.setAbstract(model.getAbstract());
            try {
                DocumentCreator.createDocument((IExternDocument)doc);
            }
            catch (IOException e) {
                this.reportException((Exception)e);
            }
            manager.commit(transaction);
            transaction = null;
            IExternDocument iExternDocument = doc;
            return iExternDocument;
        }
        catch (InvalidTransactionException e) {
            transaction = null;
        }
        finally {
            if (transaction != null) {
                manager.rollback(transaction);
            }
        }
        return null;
    }

    private NotesView getNotesView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (NotesView)page.findViewReference("com.modeliosoft.modelio.edition.notes.NotesViewID").getView(false);
    }

    private void selectDoc(IExternDocument doc) {
        NotesView notesView = this.getNotesView();
        if (notesView != null) {
            notesView.setCurrentElement((IElement)doc);
        }
    }

    private void openDoc(IExternDocument doc) {
        O.getDefault().getActivationService().fireActivate((IElement)doc);
    }

    void reportException(Exception e) {
        String title = EditionNotes.I18N.getMessage("CannotInitializeRichNoteContent", new String[0]);
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        MessageDialog.openWarning((Shell)shell, (String)title, (String)e.getLocalizedMessage());
        if (!(e instanceof InvalidModelManipulationException)) {
            LOG.error((String)"org.modelio.edition.notes", (Throwable)e);
        }
    }
}

