/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserDriver;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.mda.services.elementChooser.ElementChooserDlg;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddNoteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        NotesView view = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (view == null) {
            return null;
        }
        String noteType = event.getParameter("com.modeliosoft.modelio.edition.notes.AddNoteCommand.notetype");
        INote newNote = null;
        newNote = noteType != null ? this.createNoteFromType(view.getCurrentElement(), noteType) : this.createNoteFromUserChoice(shell, view.getCurrentElement());
        if (newNote != null) {
            this.selectNote(newNote);
        }
        return null;
    }

    public boolean isEnabled() {
        NotesView notesView = this.getNotesView();
        if (notesView == null) {
            return false;
        }
        IModelElement element = notesView.getCurrentElement();
        if (element == null) {
            return false;
        }
        return element.getElementStatus().isModifiable();
    }

    public boolean isHandled() {
        return true;
    }

    private void selectNote(INote note) {
        NotesView notesView = this.getNotesView();
        if (notesView != null) {
            notesView.setCurrentElement((IElement)note);
        }
    }

    private NotesView getNotesView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (NotesView)page.findViewReference("com.modeliosoft.modelio.edition.notes.NotesViewID").getView(false);
    }

    private INote createNoteFromType(IModelElement noteParent, String noteType) {
        IModelingSession session = EditionNotes.getInstance().getSession();
        ITransactionManager manager = session.getTransactionManager();
        ITransaction transaction = manager.createTransaction(EditionNotes.I18N.getString("AddNote"));
        INote newNote = null;
        try {
            try {
                try {
                    newNote = session.getModelFactory().createNote(noteType, noteParent, EditionNotes.I18N.getString("EnterNoteBody"));
                }
                catch (NoteTypeNotFoundException e) {
                    e.printStackTrace();
                }
                manager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    manager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                manager.rollback(transaction);
            }
        }
        return newNote;
    }

    private INote createNoteFromUserChoice(Shell parentShell, IModelElement noteParent) {
        NoteChooserDriver driver = new NoteChooserDriver(EditionNotes.getInstance().getSession(), null);
        IModelElement currentElement = noteParent;
        ElementChooserDlg dialog = new ElementChooserDlg(parentShell, (IElementChooserDriver)driver, currentElement);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return driver.getCreatedNote();
    }
}

