/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyAnnotationHandler
extends AbstractHandler {
    private Clipboard clipboard = new Clipboard(Display.getCurrent());

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NotesView notesView = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        Control control = notesView.getFocusControl();
        if (control instanceof Text) {
            ((Text)control).copy();
        } else {
            List selectedElements = notesView.getSelectedNoteItems();
            PasteElementObject toCopy = new PasteElementObject(PasteElementObject.PasteType.COPY);
            for (IElement element : selectedElements) {
                toCopy.addTransferedItems(new TransferItem(element, element.getCompositionOwner()));
            }
            this.clipboard.setContents(new Object[]{toCopy}, new Transfer[]{PasteElementTransfer.getInstance()});
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }
}

