/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveUp
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NotesView view = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        IModelElement element = view.getCurrentElement();
        List typeItems = view.getSelectedNoteItems();
        if (element instanceof IModelElement) {
            this.moveElementsUp(element, typeItems);
            view.refreshView();
        }
        return null;
    }

    public boolean isEnabled() {
        NotesView view = this.getNotesView();
        if (view == null) {
            return false;
        }
        IModelElement element = view.getCurrentElement();
        if (element == null) {
            return false;
        }
        if (!(element instanceof IModelElement)) {
            return false;
        }
        if (!element.getElementStatus().isModifiable()) {
            return false;
        }
        Class<?> currentClass = null;
        List items = view.getSelectedNoteItems();
        if (items.isEmpty()) {
            return false;
        }
        for (IModelElement me : items) {
            if (!(me instanceof INote || me instanceof IExternDocument || me instanceof IConstraint)) {
                return false;
            }
            if (currentClass == null || me.getClass().equals(currentClass)) {
                currentClass = me.getClass();
                continue;
            }
            return false;
        }
        if (INote.class.isAssignableFrom(currentClass)) {
            return this.canMoveNoteUp(element, items);
        }
        if (INote.class.isAssignableFrom(currentClass)) {
            return this.canMoveExternDocumentUp(element, items);
        }
        if (IConstraint.class.isAssignableFrom(currentClass)) {
            return this.canMoveConstraintUp(element, items);
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }

    private NotesView getNotesView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return (NotesView)page.findViewReference("com.modeliosoft.modelio.edition.notes.NotesViewID").getView(false);
    }

    private boolean canMoveNoteUp(IModelElement element, List<IModelElement> elementToMove) {
        ObList notes = element.getDescriptor();
        boolean ret = false;
        if (notes.size() > 0) {
            ret = !elementToMove.contains(notes.get(0));
        }
        return ret;
    }

    private boolean canMoveExternDocumentUp(IModelElement element, List<IModelElement> elementToMove) {
        ObList richNotes = element.getDocument();
        boolean ret = false;
        if (richNotes.size() > 0) {
            ret = !elementToMove.contains(richNotes.get(0));
        }
        return ret;
    }

    private boolean canMoveConstraintUp(IModelElement element, List<IModelElement> elementToMove) {
        ObList constraints = element.getConstraintDefinition();
        boolean ret = false;
        if (constraints.size() > 0) {
            ret = !elementToMove.contains(constraints.get(0));
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveElementsUp(IModelElement owner, List<IModelElement> elementToMove) {
        String relation;
        if (owner == null || elementToMove == null || elementToMove.isEmpty()) {
            return;
        }
        ArrayList<IElement> listToReorder = new ArrayList<IElement>();
        if (elementToMove.get(0) instanceof INote) {
            listToReorder.addAll((Collection<IElement>)owner.getDescriptor());
            relation = "Descriptor";
        } else if (elementToMove.get(0) instanceof IExternDocument) {
            listToReorder.addAll((Collection<IElement>)owner.getDocument());
            relation = "Document";
        } else {
            if (!(elementToMove.get(0) instanceof IConstraint)) return;
            listToReorder.addAll((Collection<IElement>)owner.getConstraintDefinition());
            relation = "ConstraintDefinition";
        }
        int nMoves = 0;
        for (IElement iElement : elementToMove) {
            int index = listToReorder.indexOf(iElement);
            if (index <= 0) continue;
            listToReorder.remove(index);
            listToReorder.add(index - 1, iElement);
            ++nMoves;
        }
        if (nMoves <= 0) return;
        IModelingSession iModelingSession = EditionNotes.getInstance().getSession();
        ITransactionManager transactionManager = iModelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("MoveUp");
        try {
            try {
                ModelServices.reorderDep((IElement)owner, (String)relation, (List)new ObList(listToReorder.toArray(new IElement[listToReorder.size()])));
                transactionManager.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (RuntimeException e) {
                EditionNotes.LOG.error((Throwable)e);
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }
}

