/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveAnnotationHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NotesView notesView = (NotesView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (notesView == null) return null;
        List noteItems = notesView.getSelectedNoteItems();
        ITransactionManager transactionManager = EditionNotes.getInstance().getSession().getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("NoteDeletion");
        try {
            try {
                for (IModelElement noteItem : noteItems) {
                    noteItem.delete();
                }
                transactionManager.commit(transaction);
                transaction = null;
                return null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.edition.notes", (Throwable)e);
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return false;
        }
        NotesView notesView = (NotesView)page.findViewReference("com.modeliosoft.modelio.edition.notes.NotesViewID").getView(false);
        if (notesView == null) {
            return false;
        }
        IModelElement element = notesView.getCurrentElement();
        if (element == null) {
            return false;
        }
        if (!element.getElementStatus().isModifiable()) {
            return false;
        }
        List noteItems = notesView.getSelectedNoteItems();
        for (IModelElement me : noteItems) {
            if (me.getElementStatus().isModifiable()) continue;
            return false;
        }
        return noteItems.size() > 0;
    }

    public boolean isHandled() {
        return true;
    }
}

