/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.noteChooser;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserContentProvider;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserDriver;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserLabelProvider;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserModel;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteChooserSorter;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteTypeChooserAdapter;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class NoteChooserDriver
implements IElementChooserDriver {
    IModelingSession session;
    private INote createdNote;
    private IModelElement element;
    private String initialContent;
    private NoteChooserModel leftModel;
    private TreeViewer leftViewer;
    private NoteChooserSelectionListener noteSelectionListener = null;

    public NoteChooserDriver(IModelingSession session, Object selectedAnnotationAdapter) {
        this.session = session;
        this.createdNote = null;
        this.initialContent = EditionNotes.I18N.getString("EnterNoteBody");
        this.noteSelectionListener = new NoteChooserSelectionListener(this);
    }

    public StructuredViewer createViewer(Composite parent) {
        this.leftViewer = new TreeViewer(parent, 2050);
        this.leftViewer.setContentProvider((IContentProvider)new NoteChooserContentProvider());
        this.leftViewer.setLabelProvider((IBaseLabelProvider)new NoteChooserLabelProvider(this.session));
        this.leftViewer.setSorter((ViewerSorter)new NoteChooserSorter());
        this.leftViewer.setAutoExpandLevel(-1);
        this.leftViewer.addSelectionChangedListener((ISelectionChangedListener)this.noteSelectionListener);
        return this.leftViewer;
    }

    public INote getCreatedNote() {
        return this.createdNote;
    }

    public String getLeftLabel() {
        return EditionNotes.I18N.getString("AddNoteLeftLabel");
    }

    public String getTitle() {
        return EditionNotes.I18N.getString("NoteChooserTitle");
    }

    public void init(IElement anElement) {
        if (anElement instanceof IModelElement) {
            this.element = (IModelElement)anElement;
            this.leftModel = new NoteChooserModel(this.session, this.element);
            this.leftViewer.setInput((Object)this.leftModel);
            this.setExpandedState();
        }
    }

    public void performCancel() {
    }

    public void performFinish(StructuredViewer viewer, List<Object> selection) {
        ITransactionManager manager = this.session.getTransactionManager();
        ITransaction transaction = manager.createTransaction(EditionNotes.I18N.getString("AddNote"));
        try {
            try {
                IModelFactory factory = this.session.getModelFactory();
                for (Object obj : selection) {
                    NoteTypeChooserAdapter adapter = (NoteTypeChooserAdapter)obj;
                    INoteType noteType = adapter.getNoteType();
                    this.createdNote = factory.createNote();
                    this.createdNote.setModel(noteType);
                    this.createdNote.setContent(this.initialContent);
                    this.element.addDescriptor(this.createdNote);
                }
                manager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    manager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                manager.rollback(transaction);
            }
        }
    }

    public String getMessage() {
        return EditionNotes.I18N.getString("NoteChooserMessage");
    }

    public String getShellTitle() {
        return EditionNotes.I18N.getString("NoteChooserShellTitle");
    }

    protected void finalize() throws Throwable {
        this.leftViewer.removeSelectionChangedListener((ISelectionChangedListener)this.noteSelectionListener);
        super.finalize();
    }

    private void setExpandedState() {
        this.leftViewer.setAutoExpandLevel(3);
    }

    static /* synthetic */ TreeViewer access$0(NoteChooserDriver noteChooserDriver) {
        return noteChooserDriver.leftViewer;
    }
}

