/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.noteChooser;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.ui.EditionUI;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteMdacAdapter;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteStereotypeChooserAdapter;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteTypeChooserAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NoteChooserLabelProvider
extends LabelProvider {
    private IModelingSession modelingSession = null;

    public Image getImage(Object element) {
        Image dotImage = EditionUI.getSharedImages().getImage("edition.dot");
        if (element instanceof NoteMdacAdapter) {
            NoteMdacAdapter adapter = (NoteMdacAdapter)element;
            IModule module = adapter.getMdac();
            return this.getModuleImage(module);
        }
        if (element instanceof NoteTypeChooserAdapter) {
            return StandardImageService.getImage((String)"mm.Note");
        }
        if (element instanceof NoteStereotypeChooserAdapter) {
            NoteStereotypeChooserAdapter stereotypeAdapter = (NoteStereotypeChooserAdapter)element;
            Image image = this.getStereotypeImage(stereotypeAdapter.getStereotype());
            if (image == null) {
                image = dotImage;
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof NoteMdacAdapter) {
            IMdac module;
            IMdacRegistry mdacRegistry = null;
            NoteMdacAdapter adapter = (NoteMdacAdapter)element;
            if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(adapter.getMdac())) != null) {
                return module.getLabel();
            }
            return adapter.getMdac().getName();
        }
        if (element instanceof NoteTypeChooserAdapter) {
            StringBuffer noteTypeLabel = new StringBuffer();
            NoteTypeChooserAdapter adapter = (NoteTypeChooserAdapter)element;
            String label = adapter.getNoteType().getLabel();
            if (!"".equals(label)) {
                noteTypeLabel.append(label);
            } else {
                noteTypeLabel.append(adapter.getNoteType().getName());
            }
            return noteTypeLabel.toString();
        }
        if (element instanceof NoteStereotypeChooserAdapter) {
            StringBuffer noteTypeLabel = new StringBuffer();
            NoteStereotypeChooserAdapter adapter = (NoteStereotypeChooserAdapter)element;
            noteTypeLabel.append("<<");
            String label = adapter.getStereotype().getLabel();
            if (!"".equals(label)) {
                noteTypeLabel.append(label);
            } else {
                noteTypeLabel.append(adapter.getStereotype().getName());
            }
            noteTypeLabel.append(">>");
            return noteTypeLabel.toString();
        }
        return element.toString();
    }

    public NoteChooserLabelProvider(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
    }

    private Image getModuleImage(IModule moduleModel) {
        ImageDescriptor defaultModuleDescriptor;
        IMdacRegistry mdacRegistry;
        IMdac module;
        String key = "MDAC." + moduleModel.getName();
        Image moduleImage = StandardImageService.getImage((String)key);
        if (moduleImage != null) {
            return moduleImage;
        }
        if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(moduleModel)) != null) {
            ImageDescriptor moduleImageDescriptor = module.getMdacImageDescriptor();
            if (moduleImageDescriptor != null) {
                StandardImageService.declareImage((String)key, (ImageDescriptor)moduleImageDescriptor);
                moduleImage = StandardImageService.getImage((String)key);
            }
            if (moduleImage != null) {
                return moduleImage;
            }
        }
        if ((moduleImage = StandardImageService.getImage((String)"DefaultModuleImage")) == null && (defaultModuleDescriptor = StandardImageService.getUmlImageDescriptor((IElement)moduleModel)) != null) {
            StandardImageService.declareImage((String)"DefaultModuleImage", (ImageDescriptor)defaultModuleDescriptor);
            moduleImage = StandardImageService.getImage((String)"DefaultModuleImage");
        }
        return moduleImage;
    }

    private Image getStereotypeImage(IStereotype stereotype) {
        Image image = null;
        IMetamodelExtensions metamodelExtensions = this.modelingSession.getModel().getMetamodelExtensions();
        IModule module = metamodelExtensions.getModule(stereotype);
        if (module != null) {
            IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(module);
            image = mdac.getImage(stereotype, IMdac.ImageType.ICON);
        }
        return image;
    }
}

