/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.noteChooser;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteMdacAdapter;
import java.util.HashMap;
import java.util.Map;

public class NoteChooserModel {
    private IModelingSession session;
    Map<IModule, NoteMdacAdapter> mdacAdapters;
    private IModelElement element;

    public NoteChooserModel(IModelingSession session, IModelElement element) {
        this.session = session;
        this.element = element;
        this.mdacAdapters = new HashMap();
        this.init();
    }

    public NoteChooserModel(IModelingSession session) {
        this.session = session;
        this.element = null;
        this.mdacAdapters = new HashMap();
    }

    private void init() {
        IMetamodelExtensions extensions = this.session.getModel().getMetamodelExtensions();
        if (this.session == null) {
            return;
        }
        ObList stereotypes = this.element.getExtension();
        for (IStereotype stereotype : stereotypes) {
            IModule module;
            boolean hasNoteTypes = false;
            ObList noteTypes = stereotype.getDefinedNoteType();
            for (INoteType noteType : noteTypes) {
                if (noteType.isHidden()) continue;
                hasNoteTypes = true;
            }
            if (!hasNoteTypes || (module = extensions.getModule(stereotype)) == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addStereotype(module, stereotype);
        }
        ObList noteTypes = extensions.getNoteTypes(this.element.getClass());
        for (INoteType noteType : noteTypes) {
            IModule module;
            if (!noteType.isHidden() && noteType.getOwnerReference() != null) {
                module = extensions.getModule(noteType);
                if (module == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
                this.addNoteType(module, noteType);
                continue;
            }
            if (noteType.isHidden() || noteType.getOwnerStereotype() == null || !this.element.isStereotyped(noteType.getOwnerStereotype().getName()) || (module = extensions.getModule(noteType)) == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addNoteType(module, noteType);
        }
    }

    private void addNoteType(IModule mdac, INoteType noteType) {
        NoteMdacAdapter adapter = (NoteMdacAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new NoteMdacAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        adapter.addNoteType(noteType);
    }

    public Map<IModule, NoteMdacAdapter> getMdacAdapters() {
        return this.mdacAdapters;
    }

    private void addStereotype(IModule mdac, IStereotype stereotype) {
        NoteMdacAdapter adapter = (NoteMdacAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new NoteMdacAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        adapter.addStereotype(stereotype, this.element);
    }
}

