/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.noteChooser;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteStereotypeChooserAdapter;
import com.modeliosoft.modelio.edition.notes.noteChooser.NoteTypeChooserAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;

public class NoteMdacAdapter
implements IAdaptable {
    private List<IAdaptable> adapters;
    private IModule mdac;

    public NoteMdacAdapter(IModule mdac) {
        this.mdac = mdac;
        this.adapters = new ArrayList();
    }

    public void addNoteType(INoteType noteType) {
        IStereotype documented = noteType.getOwnerStereotype();
        if (documented == null) {
            NoteTypeChooserAdapter adapter = new NoteTypeChooserAdapter(noteType, (IAdaptable)this);
            this.adapters.add(adapter);
        } else {
            for (IAdaptable adapter : this.adapters) {
                NoteStereotypeChooserAdapter stereotypeAdapter;
                IStereotype currentStereotype;
                if (!(adapter instanceof NoteStereotypeChooserAdapter) || !this.isSubStereotype(documented, currentStereotype = (stereotypeAdapter = (NoteStereotypeChooserAdapter)adapter).getStereotype())) continue;
                stereotypeAdapter.addNoteType(noteType);
            }
        }
    }

    public void removeStereotype(NoteTypeChooserAdapter adapter) {
        this.adapters.remove(adapter);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IModule getMdac() {
        return this.mdac;
    }

    public List<IAdaptable> getAdapters() {
        return this.adapters;
    }

    private boolean isSubStereotype(IStereotype parentStereotype, IStereotype currentStereotype) {
        if (currentStereotype == null) {
            return false;
        }
        if (parentStereotype.equals((Object)currentStereotype)) {
            return true;
        }
        IStereotype stereotype = currentStereotype.getParent();
        boolean result = false;
        if (stereotype != null) {
            result = this.isSubStereotype(parentStereotype, stereotype);
        }
        return result;
    }

    public void addStereotype(IStereotype stereotype, IModelElement element) {
        NoteStereotypeChooserAdapter adapter = new NoteStereotypeChooserAdapter(stereotype, this);
        this.adapters.add(adapter);
    }

    public NoteStereotypeChooserAdapter getAdapter(IStereotype stereotype) {
        for (IAdaptable adpater : this.adapters) {
            NoteStereotypeChooserAdapter stereotypeAdapter;
            if (!(adpater instanceof NoteStereotypeChooserAdapter) || !(stereotypeAdapter = (NoteStereotypeChooserAdapter)adpater).getStereotype().equals((Object)stereotype)) continue;
            return stereotypeAdapter;
        }
        return null;
    }
}

