/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.edition.notes.view.data.NoteViewContentPanel;
import com.modeliosoft.modelio.edition.notes.view.tree.NoteViewTreePanel;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.ViewPart;

public class NotesView
extends ViewPart
implements ISessionListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.edition.notes.NotesViewID";
    private NoteViewTreePanel treePanel = null;
    private NoteViewContentPanel contentPanel = null;
    private LayoutChangeListener layoutChangeListener = null;
    protected IModelElement currentElement;
    private SelectionListener selectionListener;
    private ModelChangeListener modelChangeListener;
    private NavigationListener navigationListener;
    private SelectionChangedListener treeSelectionListener;
    private SashForm shform = null;
    Composite theViewParent = null;

    public void createPartControl(Composite parent) {
        this.theViewParent = parent;
        this.shform = new SashForm(parent, 256);
        this.shform.setLayout((Layout)new FillLayout());
        this.treePanel = new NoteViewTreePanel(this.shform, 0, this);
        this.contentPanel = new NoteViewContentPanel(this.shform, 0, this);
        this.treePanel.setLayout((Layout)new FillLayout());
        this.contentPanel.setLayout((Layout)new FillLayout());
        this.shform.setWeights(new int[]{30, 70});
        this.layoutChangeListener = new LayoutChangeListener(this);
        this.enableAutoLayout();
        IContextService contextService = (IContextService)this.getViewSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.bindings.context.NotesViewID");
        this.setTitleToolTip(EditionNotes.I18N.getString("NotesTabTooltip"));
        this.treeSelectionListener = new SelectionChangedListener(this);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.treeSelectionListener);
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClicklistener());
        this.getSite().setSelectionProvider((ISelectionProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setHorizontalLayout() {
        this.shform.setOrientation(256);
        new Sash((Composite)this.shform, 2560);
    }

    public void setVerticalLayout() {
        this.shform.setOrientation(512);
        new Sash((Composite)this.shform, 2304);
    }

    public void enableAutoLayout() {
        this.theViewParent.addControlListener((ControlListener)this.layoutChangeListener);
    }

    public void disableAutoLayout() {
        this.theViewParent.removeControlListener((ControlListener)this.layoutChangeListener);
    }

    public void setFocus() {
        this.treePanel.setFocus();
    }

    public void sessionOpened(IModelingSession session) {
        this.navigationListener = new NavigationListener(this);
        O.getDefault().getNavigateService().addNavigationListener((INavigationListener)this.navigationListener);
        this.modelChangeListener = new ModelChangeListener(this);
        session.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
        session.getModel().addStatusListener((IStatusChangeListener)this.modelChangeListener);
    }

    public void sessionClosed(IModelingSession session) {
        this.setCurrentElement(null);
        session.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
        session.getModel().removeStatusListener((IStatusChangeListener)this.modelChangeListener);
        this.modelChangeListener = null;
        O.getDefault().getNavigateService().removeNavigationListener((INavigationListener)this.navigationListener);
        this.navigationListener = null;
    }

    public TreeViewer getTreeViewer() {
        return this.treePanel.getTreeViewer();
    }

    public Control getFocusControl() {
        return this.theViewParent.getDisplay().getFocusControl();
    }

    public IModelElement getCurrentElement() {
        return this.currentElement;
    }

    public void setCurrentElement(IElement selectedElement) {
        if (selectedElement == null) {
            this.currentElement = null;
            this.treePanel.setInput(null);
            this.contentPanel.setInput(null);
            return;
        }
        if (selectedElement instanceof INote) {
            this.currentElement = (IModelElement)selectedElement.getCompositionOwner();
            this.treePanel.setInput(this.currentElement, (IModelElement)selectedElement);
            this.contentPanel.setInput((IModelElement)selectedElement);
            return;
        }
        if (selectedElement instanceof IConstraint) {
            this.currentElement = (IModelElement)selectedElement.getCompositionOwner();
            this.treePanel.setInput(this.currentElement, (IModelElement)selectedElement);
            this.contentPanel.setInput((IModelElement)selectedElement);
            return;
        }
        if (selectedElement instanceof IExternDocument) {
            this.currentElement = (IModelElement)selectedElement.getCompositionOwner();
            this.treePanel.setInput(this.currentElement, (IModelElement)selectedElement);
            this.contentPanel.setInput((IModelElement)selectedElement);
            return;
        }
        if (selectedElement instanceof IModelElement) {
            this.currentElement = (IModelElement)selectedElement;
            this.contentPanel.setInput(null);
            this.treePanel.setInput(this.currentElement);
            return;
        }
        this.currentElement = null;
        this.treePanel.setInput(null);
        this.contentPanel.setInput(null);
        this.updateToolbar();
    }

    public void setCurrentNoteItem(IModelElement noteItem) {
        this.contentPanel.setInput(noteItem);
        this.treePanel.setLastType(noteItem);
        this.updateToolbar();
    }

    public void refreshView() {
        if (this.currentElement != null && this.currentElement.isValid()) {
            if (this.getCurrentNoteItem() != null && this.getCurrentNoteItem().isValid()) {
                this.treePanel.setInput(this.currentElement, this.getCurrentNoteItem());
            } else {
                this.treePanel.setInput(this.currentElement, null);
            }
        } else {
            this.currentElement = null;
            this.treePanel.setInput(null);
        }
        this.updateToolbar();
    }

    public void cleanCurrentNoteItemContent() {
        IModelElement noteItem = this.getCurrentNoteItem();
        if (noteItem == null) {
            return;
        }
        ITransactionManager transactionManager = O.getDefault().getModelingSession().getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Clear rich note content");
        try {
            try {
                if (noteItem instanceof INote) {
                    ((INote)noteItem).setContent("");
                } else if (noteItem instanceof IConstraint) {
                    ((IConstraint)noteItem).setBody("");
                } else if (noteItem instanceof IExternDocument) {
                    ((IExternDocument)noteItem).setAbstract("");
                }
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    public IModelElement getCurrentNoteItem() {
        return this.contentPanel.getCurrentInput();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.selectionListener = new SelectionListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.selectionListener);
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.selectionListener);
        this.selectionListener = null;
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.treeSelectionListener);
        this.treeSelectionListener = null;
        super.dispose();
    }

    public List<IModelElement> getSelectedNoteItems() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    private void updateToolbar() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)item;
                commandItem.update();
            }
            ++n2;
        }
    }

    static /* synthetic */ NoteViewContentPanel access$0(NotesView notesView) {
        return notesView.contentPanel;
    }
}

