/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view.data;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.edition.notes.view.data.INoteContent;
import com.modeliosoft.modelio.edition.notes.view.data.constraints.ConstraintContentComposite;
import com.modeliosoft.modelio.edition.notes.view.data.externs.ExternNoteContentComposite;
import com.modeliosoft.modelio.edition.notes.view.data.notes.NoteContentComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NoteViewContentPanel
extends Composite {
    private INoteContent annotationContent = null;
    private NotesView view = null;
    private IModelElement element = null;
    private IModelingSession modelingSession = null;
    private StackLayout stackLayout = null;
    private NoteContentComposite noteContentComposite = null;
    private Composite contentArea = null;
    private ConstraintContentComposite constraintContentComposite = null;
    private ExternNoteContentComposite externNoteContentComposite;

    public NoteViewContentPanel(SashForm sash, int style, NotesView view) {
        super((Composite)sash, style);
        this.view = view;
        this.createGUI();
    }

    private void createGUI() {
        this.contentArea = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        this.contentArea.setLayout((Layout)this.stackLayout);
        this.noteContentComposite = new NoteContentComposite(this.contentArea, 0, this.view);
        this.constraintContentComposite = new ConstraintContentComposite(this.contentArea, 0, this.view);
        this.externNoteContentComposite = new ExternNoteContentComposite(this.contentArea, 0, this.view);
    }

    public void setInput(IModelElement element) {
        if (this.annotationContent != null) {
            this.annotationContent.setInput(null, null);
            this.annotationContent.stop();
            this.annotationContent = null;
            this.stackLayout.topControl = null;
        }
        if (element == null || !element.isValid()) {
            this.annotationContent = null;
            this.contentArea.layout();
            return;
        }
        if (element instanceof INote) {
            this.element = element;
            this.annotationContent = this.noteContentComposite;
        } else if (element instanceof IConstraint) {
            this.element = element;
            this.annotationContent = this.constraintContentComposite;
        } else if (element instanceof IExternDocument) {
            this.element = element;
            this.annotationContent = this.externNoteContentComposite;
        }
        if (this.annotationContent != null && this.element.isValid()) {
            this.annotationContent.start(this.modelingSession);
            this.annotationContent.setInput(this.element, (IModelElement)this.element.getCompositionOwner());
            this.stackLayout.topControl = this.annotationContent.getControl();
        }
        this.contentArea.layout();
    }

    public void start(IModelingSession session) {
        this.modelingSession = session;
    }

    public void stop() {
        this.modelingSession = null;
    }

    public IModelElement getCurrentInput() {
        if (this.annotationContent != null) {
            return this.annotationContent.getNoteElement();
        }
        return null;
    }
}

