/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view.data.notes;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.edition.notes.view.data.INoteContent;
import com.modeliosoft.modelio.edition.notes.view.data.notes.NoteContentComposite;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NoteContentComposite
extends Composite
implements INoteContent {
    private INote note = null;
    private IModelElement annotedElement = null;
    private Text noteText = null;
    private NotesView view = null;
    private IModelingSession modelingSession = null;
    private NoteContentModifier noteModifier = null;

    public NoteContentComposite(Composite parentComposite, int style, NotesView view) {
        super(parentComposite, style);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        this.noteText = new Text((Composite)this, 2624);
        this.noteText.setBackground(UIColor.TEXT_READONLY_BG);
        this.noteModifier = new NoteContentModifier(null);
    }

    public void setInput(IModelElement aNote, IModelElement annotedElement) {
        this.note = (INote)aNote;
        this.annotedElement = annotedElement;
        if (this.note != null) {
            this.noteText.setText(this.note.getContent());
            this.noteText.setData((Object)this.note);
        } else {
            this.noteText.setText("");
            this.noteText.setData(null);
        }
    }

    public void start(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.noteText.addFocusListener((FocusListener)this.noteModifier);
        this.noteText.addKeyListener((KeyListener)this.noteModifier);
    }

    public void stop() {
        this.modelingSession = null;
        this.noteText.removeFocusListener((FocusListener)this.noteModifier);
        this.noteText.removeKeyListener((KeyListener)this.noteModifier);
    }

    public Control getControl() {
        return this;
    }

    public IModelElement getNoteElement() {
        return this.note;
    }

    public IModelElement getAnnotedElement() {
        return this.annotedElement;
    }
}

