/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view.tree;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.TreeItem;

public class ElementNameModifier
implements ICellModifier,
KeyListener {
    private NotesView noteView;

    public ElementNameModifier(NotesView noteView) {
        this.noteView = noteView;
    }

    public boolean canModify(Object object, String property) {
        return this.noteView.getSelectedNoteItems().size() == 1 && this.isEditable(object);
    }

    public Object getValue(Object object, String property) {
        if (object instanceof IModelElement) {
            return ((IModelElement)object).getName();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modify(Object object, String property, Object value) {
        IModelElement element;
        TreeItem item;
        Object data;
        if (!(object instanceof TreeItem) || !((data = (item = (TreeItem)object).getData()) instanceof IModelElement) || (element = (IModelElement)data).getName().equals(value)) return;
        ITransactionManager transactionManager = EditionNotes.getInstance().getSession().getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Rename");
        try {
            try {
                element.setName((String)value);
                transactionManager.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (Exception e) {
                EditionNotes.LOG.error((Throwable)e);
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private boolean isEditable(Object object) {
        if (object instanceof IConstraint || object instanceof IExternDocument) {
            return ((IModelElement)object).getElementStatus().isModifiable();
        }
        return false;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        List selectedItems;
        if (e.keyCode == 0x100000B && (selectedItems = this.noteView.getSelectedNoteItems()).size() == 1) {
            Object selectedObject = selectedItems.get(0);
            this.noteView.getTreeViewer().editElement(selectedObject, 0);
        }
    }
}

