/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view.tree;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.app.StatusImageDecorator;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.edition.notes.plugin.EditionNotes;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NoteViewTreeLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element instanceof INote) {
            return this.getNoteImage((INote)element);
        }
        if (element instanceof IConstraint) {
            return this.getConstraintImage((IConstraint)element);
        }
        if (element instanceof IExternDocument) {
            IExternDocument externDocument = (IExternDocument)element;
            String mimeType = externDocument.getMimeType();
            DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getDocumentFormatForMime(mimeType);
            if (format != null && format.getIconDescriptor() != null) {
                return this.getCmsDecoratedImage(format.toString(), externDocument.getElementStatus(), format.getIconDescriptor());
            }
            return StandardImageService.getCmsStereotypedImage((IElement)externDocument, null);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof INote) {
            INote note = (INote)element;
            INoteType type = note.getModel();
            if (type != null) {
                return type.getLabel().isEmpty() ? type.getName() : type.getLabel();
            }
            return EditionNotes.I18N.getString("Note");
        }
        if (element instanceof IExternDocument) {
            IExternDocument document = (IExternDocument)element;
            IExternDocumentType type = document.getType();
            if (type != null) {
                String label;
                String name = document.getName();
                if (!name.isEmpty()) {
                    name = String.valueOf(name) + " ";
                }
                if (!(label = type.getLabel()).isEmpty()) {
                    return String.valueOf(name) + "[" + label + "]";
                }
                return String.valueOf(name) + "[" + type.getName() + "]";
            }
            return EditionNotes.I18N.getString("ExternDocument");
        }
        if (element instanceof IConstraint) {
            IStereotype stereotype;
            IConstraint constraint = (IConstraint)element;
            String name = constraint.getName();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            ObList stereotypes = constraint.getExtension();
            if (stereotypes.size() > 0 && (stereotype = this.getFirstSelected((List)stereotypes)) != null) {
                return stereotype.getLabel().isEmpty() ? stereotype.getName() : stereotype.getLabel();
            }
            return EditionNotes.I18N.getString("Constraint");
        }
        return element.toString();
    }

    private Image getCmsDecoratedImage(String imageKey, IElementStatus elementStatus, ImageDescriptor descriptor) {
        String key = "MDAC." + imageKey + ".ICON." + StatusImageDecorator.getStateKey((IElementStatus)elementStatus);
        Image image = StandardImageService.getImage((String)key);
        if (image == null) {
            ImageDescriptor newImage = StatusImageDecorator.buildDecoratedImage((ImageDescriptor)descriptor, (IElementStatus)elementStatus);
            StandardImageService.declareImage((String)key, (ImageDescriptor)newImage);
            image = StandardImageService.getImage((String)key);
        }
        return image;
    }

    private Image getConstraintImage(IConstraint constraint) {
        return StandardImageService.getCmsStereotypedImage((IElement)constraint, null);
    }

    private IStereotype getFirstSelected(List<IStereotype> stereotypes) {
        IMetamodelExtensions extensions = EditionNotes.getInstance().getSession().getModel().getMetamodelExtensions();
        for (IStereotype stereotype : stereotypes) {
            IModule module = extensions.getModule(stereotype);
            if (module == null) continue;
            return stereotype;
        }
        return null;
    }

    private Image getNoteImage(INote note) {
        return StandardImageService.getCmsStereotypedImage((IElement)note, null);
    }
}

