/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.notes.view.tree;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.edition.notes.dnd.NoteDragListener;
import com.modeliosoft.modelio.edition.notes.view.NotesView;
import com.modeliosoft.modelio.edition.notes.view.tree.ElementEditorActivationStrategy;
import com.modeliosoft.modelio.edition.notes.view.tree.ElementNameModifier;
import com.modeliosoft.modelio.edition.notes.view.tree.NoteViewTreeContentProvider;
import com.modeliosoft.modelio.edition.notes.view.tree.NoteViewTreeLabelProvider;
import java.util.Iterator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class NoteViewTreePanel
extends Composite {
    private NotesView view = null;
    private ElementNameModifier constraintNameModifier = null;
    private IModelElement element;
    private NoteViewTreeLabelProvider labelProvider;
    private String lastSelectedType = "";
    private TreeViewer treeViewer = null;

    public NoteViewTreePanel(SashForm sash, int style, NotesView view) {
        super((Composite)sash, style);
        this.view = view;
        this.labelProvider = new NoteViewTreeLabelProvider();
        this.createGUI();
    }

    private void createGUI() {
        Composite treeArea = new Composite((Composite)this, 0);
        treeArea.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(treeArea, 2562);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new NoteViewTreeContentProvider());
        this.treeViewer.setAutoExpandLevel(3);
        this.initEditor();
        this.initDragSupport();
        this.hookContextMenu();
    }

    public boolean setFocus() {
        return this.treeViewer.getControl().setFocus();
    }

    public void setInput(IModelElement element, IModelElement preselect) {
        Control control = this.treeViewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.element = element;
        this.treeViewer.setInput((Object)this.element);
        if (this.element != null) {
            if (preselect != null) {
                this.select((IElement)preselect, true);
            } else {
                IModelElement lastNote = this.findNoteByType(element, this.lastSelectedType);
                IModelElement firstNote = this.getFirstNote(element);
                if (lastNote != null) {
                    this.select((IElement)lastNote, true);
                } else if (firstNote != null) {
                    this.select((IElement)firstNote, false);
                }
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.view.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[]{new TextCellEditor((Composite)this.treeViewer.getTree(), 0)};
        this.treeViewer.setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.treeViewer.setColumnProperties(properties);
        this.constraintNameModifier = new ElementNameModifier(this.view);
        this.treeViewer.setCellModifier((ICellModifier)this.constraintNameModifier);
        this.treeViewer.getTree().addKeyListener((KeyListener)this.constraintNameModifier);
        ElementEditorActivationStrategy actSupport = new ElementEditorActivationStrategy((ColumnViewer)this.treeViewer);
        TreeViewerEditor.create((TreeViewer)this.treeViewer, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void initDragSupport() {
        int operations = 3;
        DragSource dragSource = new DragSource(this.treeViewer.getControl(), operations);
        Transfer[] types = new Transfer[]{PasteElementTransfer.getInstance(), ModelElementTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)new NoteDragListener(this.treeViewer));
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    public void select(IElement target, boolean updateLast) {
        if (this.element == null) {
            return;
        }
        this.treeViewer.refresh();
        String previousLast = this.lastSelectedType;
        if (target instanceof IModelElement) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)target), true);
            if (!updateLast) {
                this.lastSelectedType = previousLast;
            } else {
                this.setLastType((IModelElement)target);
            }
        }
    }

    public void setInput(IModelElement element) {
        this.setInput(element, null);
    }

    public void setLastType(IModelElement elt) {
        if (elt instanceof INote) {
            this.lastSelectedType = ((INote)elt).getModel().getName();
        } else if (elt instanceof IExternDocument) {
            this.lastSelectedType = ((IExternDocument)elt).getType().getName();
        } else if (elt instanceof IConstraint) {
            this.lastSelectedType = this.getConstraintName((IConstraint)elt);
        }
    }

    private IModelElement getFirstNote(IModelElement element) {
        Iterator iterator = element.getDocument().iterator();
        if (iterator.hasNext()) {
            IExternDocument doc = (IExternDocument)iterator.next();
            return doc;
        }
        iterator = element.getDescriptor().iterator();
        if (iterator.hasNext()) {
            INote note = (INote)iterator.next();
            return note;
        }
        iterator = element.getConstraintDefinition().iterator();
        if (iterator.hasNext()) {
            IConstraint constraint = (IConstraint)iterator.next();
            return constraint;
        }
        return null;
    }

    private IModelElement findNoteByType(IModelElement element, String lastType) {
        for (IExternDocument doc : element.getDocument()) {
            if (!lastType.equals(doc.getType().getName())) continue;
            return doc;
        }
        for (INote note : element.getDescriptor()) {
            if (!lastType.equals(note.getModel().getName())) continue;
            return note;
        }
        return null;
    }

    private String getConstraintName(IConstraint constraint) {
        IStereotype stereotype;
        String name = constraint.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        ObList stereotypes = constraint.getExtension();
        if (stereotypes.size() > 0 && (stereotype = (IStereotype)stereotypes.get(0)) != null) {
            return stereotype.getLabel().isEmpty() ? stereotype.getName() : stereotype.getLabel();
        }
        return "Constraint";
    }

    static /* synthetic */ void access$0(NoteViewTreePanel noteViewTreePanel, IMenuManager iMenuManager) {
        noteViewTreePanel.fillContextMenu(iMenuManager);
    }
}

