/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui;

import com.modeliosoft.modelio.core.ui.ISharedImages;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class SharedImages
implements ISharedImages {
    private static final ImageRegistry IMAGE_REGISTRY = new ImageRegistry();

    public SharedImages() {
        this.declareImages();
    }

    protected void finalize() throws Throwable {
    }

    public Image getImage(String symbolicName) {
        Image image = IMAGE_REGISTRY.get(symbolicName);
        return image;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        ImageDescriptor desc = IMAGE_REGISTRY.getDescriptor(symbolicName);
        return desc;
    }

    public void declareImage(String symbolicName, ImageDescriptor descriptor) {
        IMAGE_REGISTRY.put(symbolicName, descriptor);
    }

    private void declareImages() {
        this.declareImage("edition.element.chooser.add", "icons/add_16.png");
        this.declareImage("edition.element.chooser.remove", "icons/remove_16.png");
        this.declareImage("edition.header.left", "icons/headerleft.png");
        this.declareImage("edition.mdacomponent", "icons/mdacomponent_16.png");
        this.declareImage("edition.delete", "icons/delete_16.png");
        this.declareImage("edition.addnote", "icons/addNote_16.png");
        this.declareImage("edition.addconstraint", "icons/addConstraint_16.png");
        this.declareImage("edition.removenote", "icons/removeNote_16.png");
        this.declareImage("edition.cleannote", "icons/cleanNote_16.png");
        this.declareImage("edition.dot", "icons/dot_16.png");
    }

    public void declareImage(String symbolicName, String relativePath) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.core.ui");
        Path bitmapPath = new Path(relativePath);
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        this.declareImage(symbolicName, desc);
    }
}

