/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.causeanalyzer;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IObjectNode;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.information.IInformationFlow;
import com.modeliosoft.modelio.api.model.uml.information.IInformationItem;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IUsage;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IAttributeLink;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IBinding;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageMerge;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.statik.IRaisedException;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateBinding;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCaseDependency;
import com.modeliosoft.modelio.api.utils.DefaultMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import java.util.Iterator;

class CauseLabelProvider
extends DefaultMetamodelVisitor {
    private static CauseLabelProvider singleton = new CauseLabelProvider();

    public static String get(IElement el) {
        return (String)el.accept((IMetamodelVisitor)singleton);
    }

    public Object visitAssociationEnd(IAssociationEnd theAssociationEnd) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.association_role", new String[]{theAssociationEnd.getName(), ((IAssociationEnd)theAssociationEnd.getOppositeEnds().get(0)).getOwner().getName()});
    }

    public Object visitAttribute(IAttribute theAttribute) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.attribute", new String[]{theAttribute.getName(), theAttribute.getType().getName()});
    }

    public Object visitGeneralization(IGeneralization theGeneralization) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.generalization", new String[]{theGeneralization.getSubType().getName(), theGeneralization.getSuperType().getName()});
    }

    public Object visitNamespaceUse(INamespaceUse theNSU) {
        INameSpace user = theNSU.getuser();
        INameSpace used = theNSU.getused();
        return CoreUi.I18N.getMessage("causeanalyzer.cause.namespaceuse", new String[]{user.getClass().getSimpleName().substring(2), user.getName(), used.getClass().getSimpleName().substring(2), used.getName()});
    }

    public Object visitModelElement(IModelElement theModelElement) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.unknowncause", new String[]{theModelElement.getName(), theModelElement.getMetaclassName()});
    }

    public Object visitElementImport(IElementImport theElementImport) {
        INameSpace src = theElementImport.getImportingNameSpace();
        if (src == null) {
            src = theElementImport.getImportingOperation();
        }
        return CoreUi.I18N.getMessage("causeanalyzer.cause.element_import", new String[]{src.getName(), theElementImport.getImportedElement().getName()});
    }

    public Object visitParameter(IParameter theParameter) {
        IOperation op = (IOperation)theParameter.getCompositionOwner();
        if (theParameter.equals((Object)op.getReturn())) {
            return CoreUi.I18N.getMessage("causeanalyzer.cause.return_parameter", new String[]{op.getName(), theParameter.getType().getName()});
        }
        return CoreUi.I18N.getMessage("causeanalyzer.cause.io_parameter", new String[]{op.getName(), theParameter.getName(), theParameter.getType().getName()});
    }

    public Object visitUsage(IUsage theUsage) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.usage", new String[]{theUsage.getImpacted().getName(), theUsage.getDependsOn().getName()});
    }

    public Object visitDependency(IDependency theDependency) {
        String msgName = theDependency.isStereotyped("trace") ? "causeanalyzer.cause.dependency.trace" : (theDependency.isStereotyped("flow") ? "causeanalyzer.cause.dependency.flow" : "causeanalyzer.cause.dependency.none");
        return CoreUi.I18N.getMessage(msgName, new String[]{theDependency.getImpacted().getName(), theDependency.getDependsOn().getName()});
    }

    public Object visitRaisedException(IRaisedException theRaisedException) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.raisedexception", new String[]{theRaisedException.getThrower().getName(), theRaisedException.getThrownType().getName()});
    }

    public Object visitInterfaceRealization(IInterfaceRealization theInterfaceRealization) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.interfacerealization", new String[]{theInterfaceRealization.getImplementer().getName(), theInterfaceRealization.getImplemented().getName()});
    }

    public Object visitTemplateBinding(ITemplateBinding theTemplateBinding) {
        INameSpace boundElement;
        INameSpace instanciatedTemplate = theTemplateBinding.getInstanciatedTemplate();
        if (instanciatedTemplate == null) {
            instanciatedTemplate = theTemplateBinding.getInstanciatedTemplateOperation();
        }
        if ((boundElement = theTemplateBinding.getBoundElement()) == null) {
            boundElement = theTemplateBinding.getBoundOperation();
        }
        return CoreUi.I18N.getMessage("causeanalyzer.cause.templatebinding", new String[]{instanciatedTemplate.getName(), boundElement.getName()});
    }

    public Object visitPackageMerge(IPackageMerge thePackageMerge) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.packagemerge", new String[]{thePackageMerge.getReceivingPackage().getName(), thePackageMerge.getMergedPackage().getName()});
    }

    public Object visitPackageImport(IPackageImport thePackageImport) {
        INameSpace src = thePackageImport.getImportingNameSpace();
        if (src == null) {
            src = thePackageImport.getImportingOperation();
        }
        return CoreUi.I18N.getMessage("causeanalyzer.cause.packageimport", new String[]{src.getName(), thePackageImport.getImportedPackage().getName()});
    }

    public Object visitUseCaseDependency(IUseCaseDependency theUseCaseDependency) {
        String key;
        if (theUseCaseDependency.isStereotyped("include")) {
            key = "causeanalyzer.cause.usecasedependency.include";
        } else if (theUseCaseDependency.isStereotyped("extend")) {
            key = "causeanalyzer.cause.usecasedependency.extend";
        } else {
            return super.visitUseCaseDependency(theUseCaseDependency);
        }
        return CoreUi.I18N.getMessage(key, new String[]{theUseCaseDependency.getOrigin().getName(), theUseCaseDependency.getTarget().getName()});
    }

    public Object visitBinding(IBinding theBinding) {
        IModelElement dest = theBinding.getRepresentedFeature();
        IConnectorEnd src = theBinding.getConnectorEndRole();
        if (src == null) {
            src = theBinding.getConnectorRole();
        }
        if (src == null) {
            src = theBinding.getRole();
        }
        theBinding.getOwner();
        return CoreUi.I18N.getMessage("causeanalyzer.cause.binding", new String[]{theBinding.getOwner().getName(), src.getName(), src.getMetaclassName(), dest.getName()});
    }

    public Object visitManifestation(IManifestation theManifestation) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.manifestation", new String[]{theManifestation.getOwner().getName(), theManifestation.getUtilizedElement().getName()});
    }

    public Object visitConnectorEnd(IConnectorEnd theConnector) {
        String msg1 = CoreUi.I18N.getMessage("causeanalyzer.cause.connectorend", new String[]{theConnector.getName(), ((ILinkEnd)theConnector.getOppositeEnds().get(0)).getLinked().getName()});
        IModelElement feature = theConnector.getRepresentedFeature();
        if (feature != null) {
            return String.valueOf(msg1) + "\n" + CoreUi.I18N.getMessage("causeanalyzer.cause.connectorend.represents", new String[]{theConnector.getName(), feature.getName()});
        }
        return msg1;
    }

    public Object visitBindableInstance(IBindableInstance theBindableInstance) {
        String msg1 = CoreUi.I18N.getMessage("causeanalyzer.cause.bindableinstance", new String[]{theBindableInstance.getName(), theBindableInstance.getBase().getName()});
        IModelElement feature = theBindableInstance.getRepresentedFeature();
        if (feature != null) {
            return String.valueOf(msg1) + "\n" + CoreUi.I18N.getMessage("causeanalyzer.cause.bindableinstance.represents", new String[]{theBindableInstance.getName(), feature.getName()});
        }
        return msg1;
    }

    private CauseLabelProvider() {
    }

    public Object visitAttributeLink(IAttributeLink theAttributeLink) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.attributelink", new String[]{theAttributeLink.getName(), theAttributeLink.getBase().getName()});
    }

    public Object visitInformationFlow(IInformationFlow theInformationFlow) {
        theInformationFlow.getConveyed();
        return CoreUi.I18N.getMessage("causeanalyzer.cause.informationflow", new String[]{this.getSymbol((IModelElement)theInformationFlow.getOwner()), theInformationFlow.getName(), this.getSymbol((Iterable)theInformationFlow.getInformationSource()), this.getSymbol((Iterable)theInformationFlow.getInformationTarget())});
    }

    public Object visitInformationItem(IInformationItem theInformationItem) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.informationitem", new String[]{theInformationItem.getName(), this.getSymbol((Iterable)theInformationItem.getRepresented())});
    }

    private String getSymbol(IModelElement el) {
        if (el == null) {
            return "<none>";
        }
        return el.getName();
    }

    private String getSymbol(Iterable<? extends IModelElement> elements) {
        StringBuilder s = new StringBuilder();
        Iterator<? extends IModelElement> it = elements.iterator();
        while (it.hasNext()) {
            s.append(this.getSymbol(it.next()));
            if (!it.hasNext()) continue;
            s.append(", ");
        }
        if (s.length() == 0) {
            return "<none>";
        }
        return s.toString();
    }

    public Object visitInstance(IInstance theInstance) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.instance", new String[]{theInstance.getName(), theInstance.getBase().getName()});
    }

    public Object visitLinkEnd(ILinkEnd theConnector) {
        String msg = CoreUi.I18N.getMessage("causeanalyzer.cause.linkend", new String[]{theConnector.getName(), ((ILinkEnd)theConnector.getOppositeEnds().get(0)).getLinked().getName()});
        if (theConnector.getModel() != null) {
            String msg1 = CoreUi.I18N.getMessage("causeanalyzer.cause.linkend.model", new String[]{theConnector.getLinked().getName(), theConnector.getName(), theConnector.getModel().getOwner().getName(), theConnector.getModel().getName(), ((ILinkEnd)theConnector.getOppositeEnds().get(0)).getLinked().getName()});
            return String.valueOf(msg) + "\n" + msg1;
        }
        return msg;
    }

    public Object visitObjectNode(IObjectNode theObjectNode) {
        IInstance represented = theObjectNode.getRepresented();
        if (represented == null) {
            represented = theObjectNode.getRepresentedAttribute();
        }
        if (represented == null) {
            represented = theObjectNode.getRepresentedRealParameter();
        }
        if (represented == null) {
            represented = theObjectNode.getRepresentedRole();
        }
        String msg1 = null;
        String msg2 = null;
        if (theObjectNode.getType() != null) {
            msg1 = CoreUi.I18N.getMessage("causeanalyzer.cause.objectnode.type", new String[]{theObjectNode.getName(), theObjectNode.getType().getName()});
        }
        if (represented != null) {
            msg2 = CoreUi.I18N.getMessage("causeanalyzer.cause.objectnode.represents", new String[]{theObjectNode.getName(), represented.getName(), represented.getMetaclassName()});
        }
        if (msg1 == null) {
            return msg2;
        }
        if (msg2 == null) {
            return msg1;
        }
        return String.valueOf(msg1) + "\n" + msg2;
    }

    public Object visitMessage(IMessage theMessage) {
        return CoreUi.I18N.getMessage("causeanalyzer.cause.message", new String[]{theMessage.getName(), this.getSymbol((IModelElement)theMessage.getInvoked())});
    }
}

