/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.causeanalyzer;

import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IModel;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.core.ui.causeanalyzer.TreeContentProvider;
import com.modeliosoft.modelio.core.ui.causeanalyzer.TreeLabelProvider;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ReportDialog
extends ModelioDialog
implements IModelChangeListener {
    private TreeViewer tree;
    private INamespaceUse input;
    private Group grp;
    private IModel iModel;

    public ReportDialog(Shell parentShell) {
        super(parentShell);
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public Control createContentArea(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 1;
        parent.setLayout((Layout)fillLayout);
        this.grp = new Group(parent, 0);
        this.grp.setText("");
        this.grp.setFont(CoreFontRegistry.getModifiedFont((Font)composite.getFont(), (int)1));
        this.grp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.top = new FormAttachment(0, 5);
        data1.left = new FormAttachment(0, 5);
        data1.right = new FormAttachment(100, -5);
        FormData data2 = new FormData();
        data2.top = new FormAttachment(0, 10);
        data2.left = new FormAttachment(0, 5);
        data2.right = new FormAttachment(100, -5);
        data2.bottom = new FormAttachment(100, -5);
        this.tree = new TreeViewer((Composite)this.grp, 2818);
        this.tree.setContentProvider((IContentProvider)new TreeContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.tree.getControl().setLayoutData((Object)data2);
        this.updateViewFromModel();
        this.tree.addPostSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return parent;
    }

    private void updateViewFromModel() {
        if (this.grp != null) {
            this.grp.setText(" " + this.getDescription() + "  ");
        }
        if (this.tree != null) {
            this.tree.setInput((Object)this.input);
            this.tree.expandToLevel(2);
        }
    }

    public void setModel(IModel iModel, INamespaceUse use) {
        if (this.iModel != null) {
            this.iModel.removeModelListener((IModelChangeListener)this);
        }
        this.input = use;
        this.iModel = iModel;
        iModel.addModelListener((IModelChangeListener)this);
        this.updateViewFromModel();
    }

    public boolean isDisposed() {
        Shell s = this.getShell();
        return s == null || s.isDisposed();
    }

    public void init() {
        Shell shell = this.getShell();
        this.setLogoImage(null);
        shell.setText(CoreUi.I18N.getMessage("causeanalyzer.abox.shelltext", new String[0]));
        this.setTitle(CoreUi.I18N.getMessage("causeanalyzer.abox.title", new String[0]));
        this.setMessage(CoreUi.I18N.getMessage("causeanalyzer.abox.message", new String[0]));
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        if (!this.isDisposed()) {
            if (this.input == null || !this.input.isValid()) {
                this.tree.setInput(null);
            } else {
                this.tree.refresh();
            }
            this.updateViewFromModel();
        }
    }

    private String getDescription() {
        if (this.input != null) {
            return CoreUi.I18N.getMessage("causeanalyzer.abox.main_label", new String[]{this.input.getuser().getName(), this.input.getused().getName()});
        }
        return "";
    }

    public boolean close() {
        if (this.iModel != null) {
            this.iModel.removeModelListener((IModelChangeListener)this);
            this.iModel = null;
        }
        return super.close();
    }
}

