/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import com.modeliosoft.modelio.core.ui.ktable.IHybridType;
import com.modeliosoft.modelio.core.ui.ktable.IPropertyModel;
import com.modeliosoft.modelio.core.ui.ktable.ITextComboType;
import com.modeliosoft.modelio.core.ui.ktable.editors.CheckboxCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ComboTextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.EditorFactory;
import com.modeliosoft.modelio.core.ui.ktable.editors.ElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.EnumCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.HybridCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.TextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.MultipleElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.renderers.ElementCellRenderer;
import com.modeliosoft.modelio.core.ui.ktable.renderers.HybridCellRenderer;
import com.modeliosoft.modelio.core.ui.ktable.renderers.MultipleElementCellRenderer;
import com.modeliosoft.modelio.core.ui.ktable.renderers.RendererFactory;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.editors.KTableCellEditorCheckbox;
import de.kupzog.ktable.editors.KTableCellEditorText2;
import de.kupzog.ktable.renderers.CheckableCellRenderer;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import de.kupzog.ktable.renderers.FixedCellRenderer;
import de.kupzog.ktable.renderers.TextCellRenderer;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class KeyValueModel
extends KTableDefaultModel {
    private IPropertyModel data = null;
    private ElementCellEditor elementEditor = null;
    private ElementCellRenderer elementRenderer = null;
    private HybridCellEditor hybridElementEditor;
    private MultipleElementCellEditor multipleElementEditor;
    private HybridCellRenderer hybridRenderer = null;
    private MultipleElementCellRenderer multipleElementRenderer = null;
    private final IElement editedElement;
    private RendererFactory rendererfactory = null;
    private Color oddColor = null;
    private Color evenColor = null;
    private FixedCellRenderer headerRenderer = null;
    private TextCellRenderer textRenderer = null;
    private TextCellRenderer labelRenderer = null;
    private CheckableCellRenderer boolRenderer = null;
    private TextCellRenderer objectRenderer = null;
    private KTable table = null;
    private KTableCellEditorCheckbox boolEditor = null;
    private KTableCellEditorText2 textEditor = null;
    private KTableCellEditor currentEditor = null;

    public KeyValueModel(KTable table, IElement element, IPropertyModel data) {
        this.table = table;
        this.editedElement = element;
        this.data = data;
        this.oddColor = UIColor.TABLE_ODDROW_BG;
        this.evenColor = UIColor.TABLE_EVENROW_BG;
        this.initializeRenderers();
        this.initializeEditors();
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        KTableCellEditorCheckbox editor = null;
        if (row <= 0) {
            return null;
        }
        if (col <= 0) {
            return null;
        }
        if (!this.data.isEditable(row, col)) {
            return null;
        }
        Object value = this.data.getValueAt(row, col);
        Object type = this.data.getTypeAt(row, col);
        if (col > 0) {
            if (type instanceof Class) {
                Class typeClass = (Class)type;
                if (type == Boolean.class) {
                    editor = this.boolEditor;
                } else if (type == String.class) {
                    editor = this.textEditor;
                } else if (IModelElement.class.isAssignableFrom(typeClass)) {
                    this.elementEditor.setTargetClass((Class)type);
                    editor = this.elementEditor;
                } else if (typeClass.isEnum()) {
                    editor = new EnumCellEditor(value);
                } else if (typeClass.isArray() && IModelElement[].class.isAssignableFrom(typeClass)) {
                    this.multipleElementEditor.init(this.editedElement, "", typeClass.getComponentType(), null);
                    editor = this.multipleElementEditor;
                } else if (IHybridType.class.isAssignableFrom(typeClass)) {
                    try {
                        IHybridType htype = (IHybridType)typeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        this.hybridElementEditor.setTargetClasses(htype.getTypes(this.editedElement));
                        editor = this.hybridElementEditor;
                    }
                    catch (Exception e) {
                        CoreUi.LOG.error((Throwable)e);
                    }
                } else if (ITextComboType.class.isAssignableFrom(typeClass)) {
                    try {
                        ITextComboType htype = (ITextComboType)typeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        List items = htype.getItems(this.editedElement);
                        ComboTextCellEditor comboTextEditor = new ComboTextCellEditor();
                        comboTextEditor.setItems(items.toArray(new String[0]));
                        editor = comboTextEditor;
                    }
                    catch (Exception e) {
                        CoreUi.LOG.error((Throwable)e);
                    }
                }
            } else if (type instanceof IPropertyType) {
                EditorFactory editorfactory = new EditorFactory();
                editor = editorfactory.getEditor((IPropertyType)type);
            }
        }
        if (this.currentEditor != null) {
            if (this.currentEditor instanceof ElementCellEditor) {
                ElementCellEditor elementCellEditor = (ElementCellEditor)this.currentEditor;
                elementCellEditor.forceClose();
            } else if (this.currentEditor instanceof HybridCellEditor) {
                HybridCellEditor hybridCellEditor = (HybridCellEditor)this.currentEditor;
                hybridCellEditor.forceClose();
            }
        }
        this.currentEditor = editor;
        return editor;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        DefaultCellRenderer renderer = null;
        if (row == 0) {
            return this.headerRenderer;
        }
        Object type = this.data.getTypeAt(row, col);
        if (col == 0) {
            renderer = this.rendererfactory.getLabelRenderer();
        } else if (type instanceof Class) {
            Class typeClass = (Class)type;
            renderer = this.objectRenderer;
            if (type == String.class) {
                renderer = this.textRenderer;
            } else if (type == Boolean.class) {
                renderer = this.boolRenderer;
            } else if (IModelElement.class.isAssignableFrom(typeClass)) {
                renderer = this.elementRenderer;
            } else if (IHybridType.class.isAssignableFrom(typeClass)) {
                renderer = this.hybridRenderer;
            } else if (ITextComboType.class.isAssignableFrom(typeClass)) {
                renderer = this.textRenderer;
            } else if (typeClass.isArray() && IModelElement[].class.isAssignableFrom(typeClass)) {
                renderer = this.multipleElementRenderer;
            }
        } else if (type instanceof IPropertyType) {
            renderer = this.rendererfactory.getRenderer((IPropertyType)type);
        }
        if (renderer != null) {
            renderer.setBackground(row % 2 == 0 ? this.oddColor : this.evenColor);
        }
        return renderer;
    }

    public int doGetColumnCount() {
        return this.data.getColumnNumber();
    }

    public Object doGetContentAt(int col, int row) {
        boolean i18n = false;
        Object value = this.data.getValueAt(row, col);
        String key = null;
        Object label = value;
        Object type = this.data.getTypeAt(row, col);
        if (col == 0) {
            key = (String)value;
            if (key.startsWith("=")) {
                label = key.substring(1);
                i18n = false;
            } else {
                i18n = true;
            }
        } else if (row == 0) {
            key = (String)value;
            i18n = true;
        } else if (type instanceof Class && ((Class)type).isEnum()) {
            key = ((Enum)value).name();
            i18n = true;
        } else if (type instanceof EnumType) {
            key = ((Enum)value).name();
            i18n = true;
        }
        if (i18n) {
            try {
                label = MetamodelLabels.getString((String)key);
            }
            catch (MissingResourceException e) {
                label = value;
            }
        }
        return label;
    }

    public int doGetRowCount() {
        try {
            return this.data.getRowsNumber();
        }
        catch (ObElementNotFoundException e) {
            return 0;
        }
    }

    /*
     * Exception decompiling
     */
    public void doSetContentAt(int col, int row, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getInitialColumnWidth(int column) {
        int colCount = this.data.getColumnNumber();
        int availableWidth = this.table.getClientArea().width - 18;
        if (column == 0) {
            return this.getOptimalColumnWidth(0);
        }
        int firstColumnWidth = this.getOptimalColumnWidth(0);
        return (availableWidth - firstColumnWidth) / (colCount - 1);
    }

    public int getInitialRowHeight(int row) {
        return row == 0 ? 22 : 18;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 0;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public void setColumnWidth(int col, int value) {
        super.setColumnWidth(col, value);
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    public int getColumnWidth(int col) {
        return super.getColumnWidth(col);
    }

    protected void initializeRenderers() {
        this.rendererfactory = new RendererFactory(this.table);
        this.headerRenderer = new FixedCellRenderer(0);
        this.headerRenderer.setForeground(Display.getCurrent().getSystemColor(2));
        this.headerRenderer.setBackground(Display.getCurrent().getSystemColor(22));
        this.headerRenderer.setAlignment(55);
        this.textRenderer = new TextCellRenderer(16);
        this.textRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.textRenderer.setAlignment(55);
        this.labelRenderer = new TextCellRenderer(16);
        this.labelRenderer.setAlignment(52);
        this.labelRenderer.setForeground(Display.getCurrent().getSystemColor(2));
        this.boolRenderer = new CheckableCellRenderer(16);
        this.boolRenderer.setAlignment(55);
        this.boolRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.elementRenderer = new ElementCellRenderer(this.table, 16);
        this.elementRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.elementRenderer.setAlignment(55);
        this.multipleElementRenderer = new MultipleElementCellRenderer(this.table, 16);
        this.multipleElementRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.multipleElementRenderer.setAlignment(55);
        this.hybridRenderer = new HybridCellRenderer(this.table, 16, true);
        this.hybridRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.hybridRenderer.setAlignment(55);
        this.objectRenderer = new TextCellRenderer(16);
        this.objectRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.objectRenderer.setAlignment(55);
    }

    protected void initializeEditors() {
        this.boolEditor = new CheckboxCellEditor();
        this.textEditor = new TextCellEditor();
        this.elementEditor = new ElementCellEditor();
        this.hybridElementEditor = new HybridCellEditor();
        this.multipleElementEditor = new MultipleElementCellEditor();
    }

    public IPropertyType doGetTypeAt(int col, int row) {
        Object type = this.data.getTypeAt(row, col);
        if (type instanceof IPropertyType) {
            return (IPropertyType)type;
        }
        return null;
    }

    private int getOptimalColumnWidth(int column) {
        if (column >= 0 && column < this.getColumnCount()) {
            int width;
            int optWidth = 5;
            GC gc = new GC((Drawable)this.table);
            int i = 0;
            while (i < this.getFixedHeaderRowCount()) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = 1;
            while (i < 1 + this.getRowCount() - 1) {
                width = this.getCellRenderer(column, i).getOptimalWidth(gc, column, i, this.getContentAt(column, i), true, (KTableModel)this);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            return optWidth + 10;
        }
        return -1;
    }

    public String getTooltipAt(int col, int row) {
        return String.valueOf(this.doGetContentAt(col, row));
    }
}

