/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.ui.ktable.editors.CheckboxCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ComboCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ComboTextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.EnumCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.HybridCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ModelElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ScopeRichTextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.TextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiline.MultilineTextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.MultipleElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringListCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.types.BooleanType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.EnumType;
import com.modeliosoft.modelio.core.ui.ktable.types.GhostType;
import com.modeliosoft.modelio.core.ui.ktable.types.HeaderType;
import com.modeliosoft.modelio.core.ui.ktable.types.IEditorTypeVisitor;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.ktable.types.ImageDisplayType;
import com.modeliosoft.modelio.core.ui.ktable.types.LabelType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.ListType;
import com.modeliosoft.modelio.core.ui.ktable.types.ModelElementListType;
import com.modeliosoft.modelio.core.ui.ktable.types.MultilineStringType;
import com.modeliosoft.modelio.core.ui.ktable.types.MultipleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.ScopeRichTextType;
import com.modeliosoft.modelio.core.ui.ktable.types.SingleElementType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringListType;
import com.modeliosoft.modelio.core.ui.ktable.types.StringType;
import de.kupzog.ktable.KTableCellEditor;
import java.util.List;

public class EditorFactory
implements IEditorTypeVisitor {
    private KTableCellEditor editor = null;

    public KTableCellEditor getEditor(IPropertyType type) {
        this.editor = null;
        type.accept((IEditorTypeVisitor)this);
        return this.editor;
    }

    public void visitBooleanType(BooleanType theBooleanType) {
        this.editor = new CheckboxCellEditor();
    }

    public void visitEnumStringType(EnumStringType theEnumStringType) {
    }

    public void visitEnumType(EnumType theEnumType) {
        this.editor = new EnumCellEditor((Object)theEnumType.getTheEnumeration());
    }

    public void visitGhostType(GhostType theGhostType) {
        this.editor = null;
    }

    public void visitHeaderType(HeaderType theHeaderType) {
        this.editor = null;
    }

    public void visitImageType(ImageDisplayType theImageType) {
        this.editor = null;
    }

    public void visitLabelType(LabelType theLabelType) {
        this.editor = null;
    }

    public void visitListStringType(ListStringType theListStringType) {
        ComboTextCellEditor comboTextEditor = new ComboTextCellEditor();
        List values = theListStringType.getValues();
        comboTextEditor.setItems(values.toArray(new String[values.size()]));
        this.editor = comboTextEditor;
    }

    public void visitListType(ListType theListType) {
        ComboCellEditor comboEditor = new ComboCellEditor();
        List values = theListType.getValues();
        comboEditor.setItems(values.toArray(new String[values.size()]));
        this.editor = comboEditor;
    }

    public void visitModelElementListType(ModelElementListType theModelElementListType) {
        this.editor = new ModelElementCellEditor(theModelElementListType.getAllowedClasses(), theModelElementListType.getElements(), theModelElementListType.acceptNullValue());
    }

    public void visitMultipleElementType(MultipleElementType theMultipleElementType) {
        MultipleElementCellEditor multipleEditor = new MultipleElementCellEditor();
        List allowedClasses = theMultipleElementType.getAllowedClasses();
        if (allowedClasses.size() == 1) {
            Class target = (Class)allowedClasses.get(0);
            if (IElement.class.isAssignableFrom(target)) {
                Class targetClass = (Class)allowedClasses.get(0);
                multipleEditor.init((IElement)theMultipleElementType.getEditedElement(), theMultipleElementType.getFieldName(), targetClass, theMultipleElementType.getElementFilter());
                this.editor = multipleEditor;
            } else {
                this.editor = null;
            }
        } else {
            this.editor = null;
        }
    }

    public void visitSingleElementType(SingleElementType theSingleElementType) {
        try {
            this.editor = new HybridCellEditor(theSingleElementType.acceptNullValue());
            List allowedClasses = theSingleElementType.getAllowedClasses();
            Class[] targetClasses = allowedClasses.toArray(new Class[allowedClasses.size()]);
            ((HybridCellEditor)this.editor).setTargetClasses(targetClasses);
            ((HybridCellEditor)this.editor).setElementFilter(theSingleElementType.getElementFilter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void visitStringListType(StringListType theStringListType) {
        this.editor = new StringListCellEditor(theStringListType.getTitle(), theStringListType.getMessage(), theStringListType.getSize(), theStringListType.getDetailedMessage());
    }

    public void visitStringNoValueType(StringType theStringType) {
        this.editor = new TextCellEditor();
    }

    public void visitStringType(StringType theStringType) {
        this.editor = new TextCellEditor();
    }

    public void visitMultilineStringType(MultilineStringType theMultipleStringType) {
        MultilineTextCellEditor multipleEditor = new MultilineTextCellEditor((IElement)theMultipleStringType.getEditedElement(), theMultipleStringType.getFieldName());
        this.editor = multipleEditor;
    }

    public void visitScopeRichTextType(ScopeRichTextType scopeRichTextType) {
        this.editor = new ScopeRichTextCellEditor(scopeRichTextType.getEditedElement());
    }
}

