/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.ui.text.ResultsProposalPopup;
import com.modeliosoft.modelio.api.utils.UMLMetaclassName;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.model.ElementFinder;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.ktable.KeyValueModel;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;

public class ElementCellEditor
extends KTableCellEditor
implements IPickingClient,
IEditorDropClient {
    private Class<? extends IElement> targetClass;
    private IElementFilter elementFilter = null;
    protected boolean acceptNullValue = false;
    private EditorDropListener dropListener;
    protected KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;
    protected TraverseListener travListener = new /* Unavailable Anonymous Inner Class!! */;
    Text m_Text2 = null;

    public boolean acceptDroppedElements(IElement[] target) {
        return target.length == 1 && this.targetClass.isAssignableFrom(target[0].getClass());
    }

    public boolean acceptElement(IElement target) {
        return this.targetClass.isAssignableFrom(target.getClass());
    }

    public void close(boolean save) {
    }

    public void forceClose() {
        if (this.m_Table != null) {
            super.close(true);
        }
    }

    public int getActivationSignals() {
        return 12;
    }

    public void open(KTable table, int col, int row, Rectangle rect) {
        super.open(table, col, row, rect);
        IModelElement me = (IModelElement)this.m_Model.getContentAt(this.m_Col, this.m_Row);
        String initialValue = me != null ? me.getName() : "";
        this.initAcceptNullValue(col, row);
        this.m_Text2.setText(initialValue.toString());
        this.m_Text2.selectAll();
        this.m_Text2.setVisible(true);
        this.m_Text2.setFocus();
        O.getDefault().getPickingClientService().beginPicking((IPickingClient)this);
    }

    public void pickingAborted() {
        if (this.m_Text2 != null && !this.m_Text2.isDisposed()) {
            this.m_Text2.setData(null);
            this.m_Text2.removeKeyListener((KeyListener)this.keyListener);
            this.m_Text2.removeTraverseListener(this.travListener);
            super.close(false);
            this.m_Text2 = null;
        }
    }

    public void setContent(Object content) {
        IModelElement me = (IModelElement)content;
        String text = me.getName();
        if (me.getCompositionOwner() != null) {
            text = String.valueOf(text) + "  (from " + ((IModelElement)me.getCompositionOwner()).getName() + ")";
        }
        this.m_Text2.setText(text);
        this.m_Text2.setData(content);
    }

    public void setDroppedElements(IElement[] target) {
        if (this.acceptElement(target[0])) {
            this.setContent((Object)target[0]);
            this.validate(true);
        }
    }

    public boolean setElement(IElement target) {
        if (this.acceptElement(target)) {
            this.setContent((Object)target);
            this.validate(true);
            return true;
        }
        return false;
    }

    public void setElementFilter(IElementFilter elementFilter) {
        this.elementFilter = elementFilter;
    }

    public void setTargetClass(Class<? extends IElement> targetClass) {
        this.targetClass = targetClass;
    }

    public void validate(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_Text2.getData());
        }
        this.m_Text2.setData(null);
        this.m_Text2.removeKeyListener((KeyListener)this.keyListener);
        this.m_Text2.removeTraverseListener(this.travListener);
        super.close(save);
        this.selectNextField();
        O.getDefault().getPickingClientService().endPicking((IPickingClient)this);
        this.m_Text2 = null;
    }

    protected Control createControl() {
        StringBuffer helpTooltip = new StringBuffer();
        helpTooltip.append(CoreUi.I18N.getString("AcceptedType"));
        String MetaclassName = this.targetClass.getAnnotation(UMLMetaclassName.class).value();
        helpTooltip.append(MetaclassName);
        helpTooltip.append("\n");
        helpTooltip.append("\n");
        helpTooltip.append(CoreUi.I18N.getString("ElementCellEditorTootip"));
        this.setToolTipText(helpTooltip.toString());
        this.m_Text2 = new Text((Composite)this.m_Table, 0);
        this.m_Text2.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_Text2.setData(null);
        this.m_Text2.addKeyListener((KeyListener)this.keyListener);
        this.initDropTarget();
        return this.m_Text2;
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r') {
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            Vector<Class> metaclass = new Vector<Class>();
            metaclass.add(this.targetClass);
            List elements = finder.findByName(metaclass, this.m_Text2.getText(), this.elementFilter);
            if (elements.isEmpty()) {
                String filter = String.valueOf(this.m_Text2.getText()) + ".*";
                elements = finder.search(metaclass, filter, this.elementFilter);
                if (elements.isEmpty()) {
                    MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)CoreUi.I18N.getString("ElementNotFoundTitle"), (String)CoreUi.I18N.getString("ElementNotFoundMessage"));
                    this.validate(false);
                } else if (elements.size() == 1) {
                    this.m_Text2.setData(elements.get(0));
                    this.validate(true);
                } else {
                    ResultsProposalPopup rp = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                    IModelElement selected = (IModelElement)rp.getChoice();
                    this.m_Text2.setData((Object)selected);
                    this.validate(true);
                }
            } else if (elements.size() == 1) {
                this.m_Text2.setData(elements.get(0));
                this.validate(true);
            } else {
                ResultsProposalPopup rp = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                IModelElement selected = (IModelElement)rp.getChoice();
                this.m_Text2.setData((Object)selected);
                this.validate(true);
            }
            return;
        }
        if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            String filter = String.valueOf(this.m_Text2.getText()) + ".*";
            Vector<Class> metaclass = new Vector<Class>();
            metaclass.add(this.targetClass);
            List elements = finder.search(metaclass, filter, this.elementFilter);
            if (elements.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)CoreUi.I18N.getString("ElementNotFoundTitle"), (String)CoreUi.I18N.getString("ElementNotFoundMessage"));
                this.validate(false);
            } else if (elements.size() == 1 && !this.acceptNullValue) {
                this.m_Text2.setData(elements.get(0));
                this.validate(true);
            } else {
                ResultsProposalPopup rp = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                IModelElement selected = (IModelElement)rp.getChoice();
                this.m_Text2.setData((Object)selected);
                this.validate(true);
            }
        } else if (e.character == '\u001b') {
            this.validate(false);
        } else {
            super.onKeyPressed(e);
        }
    }

    private void initAcceptNullValue(int col, int row) {
        if (this.m_Model instanceof KeyValueModel) {
            KeyValueModel keyValueModel = (KeyValueModel)this.m_Model;
            IPropertyType type = keyValueModel.doGetTypeAt(col, row);
            this.acceptNullValue = type != null ? type.acceptNullValue() : true;
        }
    }

    private void initDropTarget() {
        this.dropListener = new EditorDropListener((IEditorDropClient)this);
        int operations = 3;
        Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.m_Text2, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.dropListener);
    }

    private void selectNextField() {
        int nextCol = this.m_Col + 1;
        int nextRow = this.m_Row;
        if (nextCol > this.m_Model.getColumnCount() - 1) {
            nextCol = 1;
            ++nextRow;
        }
        if (nextRow > this.m_Model.getRowCount() - 1) {
            nextRow = 1;
        }
        this.m_Table.setSelection(nextCol, nextRow, true);
    }
}

