/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.core.ui.MetamodelLabels;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumCellEditor
extends KTableCellEditor {
    private Object[] m_enumObjects;
    private String[] m_items = null;
    private final TraverseListener travListener = new /* Unavailable Anonymous Inner Class!! */;
    private Combo m_Combo = null;
    private final KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;

    public EnumCellEditor(Object enumValue) {
        Class enumClass;
        this.m_enumObjects = enumValue instanceof Class ? ((enumClass = (Class)enumValue).isEnum() ? enumClass.getEnumConstants() : new Object[0]) : enumValue.getClass().getEnumConstants();
        this.m_items = new String[this.m_enumObjects.length];
        int i = 0;
        while (i < this.m_enumObjects.length) {
            this.m_items[i] = this.getLabelFor(this.m_enumObjects[i].toString());
            ++i;
        }
    }

    public void close(boolean save) {
    }

    public int getActivationSignals() {
        return 12;
    }

    public void open(KTable table, int row, int col, Rectangle rect) {
        super.open(table, row, col, rect);
        Object value = this.m_Model.getContentAt(this.m_Col, this.m_Row);
        this.m_Combo.setText(this.getLabelFor(value.toString()));
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y + 1, rect.width, rect.height - 2));
    }

    public void setContent(Object content) {
        this.m_Combo.setData(content);
    }

    protected Control createControl() {
        this.m_Combo = new Combo((Composite)this.m_Table, 8);
        this.m_Combo.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.m_items != null) {
            this.m_Combo.setItems(this.m_items);
        }
        this.m_Combo.addKeyListener((KeyListener)this.keyListener);
        this.m_Combo.addTraverseListener(this.travListener);
        this.m_Combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.m_Combo;
    }

    protected void onTraverse(TraverseEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: {
                break;
            }
            default: {
                super.onTraverse(e);
            }
        }
    }

    private String getLabelFor(String value) {
        String label = null;
        try {
            label = MetamodelLabels.getString((String)value);
        }
        catch (Exception e) {
            label = value;
        }
        return label;
    }

    private void selectNextField() {
        int nextCol = this.m_Col + 1;
        int nextRow = this.m_Row;
        if (nextCol > this.m_Model.getColumnCount() - 1) {
            nextCol = 1;
            ++nextRow;
        }
        if (nextRow > this.m_Model.getRowCount() - 1) {
            nextRow = 1;
        }
        this.m_Table.setSelection(nextCol, nextRow, true);
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000001) {
            if (this.m_Combo.getSelectionIndex() > 0) {
                this.m_Combo.select(this.m_Combo.getSelectionIndex() - 1);
                this.m_Combo.setSelection(new Point(0, 0));
            }
        } else if (e.keyCode == 0x1000002) {
            this.m_Combo.select(this.m_Combo.getSelectionIndex() + 1);
            this.m_Combo.setSelection(new Point(0, 0));
        } else {
            if (e.character == '\r') {
                this.validate(true);
                return;
            }
            if (e.character == '\u001b') {
                this.validate(false);
            } else {
                super.onKeyPressed(e);
            }
        }
    }

    protected void validate(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_enumObjects[this.m_Combo.getSelectionIndex()]);
        }
        if (this.m_Combo != null) {
            this.m_Combo.removeKeyListener((KeyListener)this.keyListener);
            this.m_Combo.removeTraverseListener(this.travListener);
        }
        this.m_Combo.removeKeyListener((KeyListener)this.keyListener);
        this.m_Combo.removeTraverseListener(this.travListener);
        super.close(save);
        this.selectNextField();
        this.m_Combo = null;
    }

    static /* synthetic */ Combo access$0(EnumCellEditor enumCellEditor) {
        return enumCellEditor.m_Combo;
    }
}

